#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

EthernetNetIf eth;
HTTPClient http;
HTTPStream stream;
HTTPResult result;
Ticker update;

char * location;
char temperature[3]; // two digit characters plus null terminating char
char humidity[3];
char BigBuf[512 + 1] = {0};
bool completed = false;

void request_callback(HTTPResult r) {
    result = r;
    completed = true;
}
void checkweather(void);

/* main */
int main() {
    printf("Start\n");
    printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("Setup OK\n");
    checkweather();                     // call check weather to start off
    update.attach(&checkweather, 5*60); // check the weather every 5 mins
    
    while (1) { // forever loop...weather checking will be interrupt based

    }
}
void checkweather(void) {
    stream.readNext((byte*)BigBuf, 512);
    HTTPResult r = http.get("http://wedgefest.wind.ttu.edu/obs/TTU_LBBW.html", &stream, request_callback); //Load a very large page
    while (!completed) {
        Net::poll(); //Polls the Networking stack
        if (stream.readable()) {
            BigBuf[stream.readLen()] = 0; //Transform this buffer in a zero-terminated char* string

            // look for key words in the html text
            location = strstr(BigBuf,"Temperature");
            if (location != NULL) {
                strncpy(temperature,location+43,2);
                location = NULL;
            }
            location = strstr(BigBuf,"Humidity");
            if (location != NULL) {
                strncpy(humidity,location+40,2);
                location = NULL;
            }
            stream.readNext((byte*)BigBuf, 512); //Buffer has been read, now we can put more data in it
        }
    }
    printf("\n--------------\n");
    if (result == HTTP_OK) {
        printf("Read completely\n");
        printf("Temperature: %s deg F \n",temperature);
        printf("Humidity: %s percent \n",humidity);
        completed = false; // allows the weather to be checked more than once
    } else {
        printf("Error %d\n", result);
    }
}