/* 
 * libmbed-synth An audio synthesis library capable of running
 * alongside other activities. 
 * Copyright (C) <2009> Michael Sheldon <mike@mikeasoft.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
*/

#ifndef MBED_SYNTH_H
#define MBED_SYNTH_H

#include "mbed.h"
#include "Instrument.h"
#include "PluckedGuitar.h"
#include "Note.h"
#include "Notes.h"

class Synth {

    public:
        Synth(PinName aout);
        void add_note(float frequency, float duration);
        void rest(double duration);
        void play();
        void pause();
        void stop();
        void set_repeat(bool repeat);
        void set_instrument(PluckedGuitar *instrument);
        void set_bpm(int bpm);

    protected:
        AnalogOut _aout;
        Ticker _ticker;
        int _samplerate;
        double *_samples;
        int _sample_size;
        bool _repeat;
        int _position;
        int _bpm;
        PluckedGuitar *_instrument;
        Note *_notes;
        int _num_notes;
        void _proc_sample();
};


#endif