/* 
 * libmbed-synth An audio synthesis library capable of running
 * alongside other activities. 
 * Copyright (C) <2009> Michael Sheldon <mike@mikeasoft.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
*/

#include "PluckedGuitar.h"
#include "mbed.h"

PluckedGuitar::PluckedGuitar() :
        Instrument::Instrument() {
    _decay = 1.1;
}

void PluckedGuitar::note(Note note) {
    _num_samples = _samplerate / note.frequency; 
    _duration = ((_samplerate * 60) / _bpm) * note.duration;
    _samples = (float *) malloc(_num_samples * sizeof(float));
    int i;
    _samples_played = 0;
    _position = 0;
    
    for (i = 0; i < _num_samples; i++) {
        _samples[i] = abs(sin((float) rand()));
    }
}

float PluckedGuitar::proc_sample() {
    DigitalOut l(LED2);
    if (_position == _num_samples) {
        _position = 0;
    }
    if (_samples_played > _duration) {
        l = 1;
        return -1;
    }
    if(_position == 0) {
        _samples[0] = _samples[_num_samples - 1] + (_samples[0] - _samples[_num_samples - 1]) / _decay;    
    } else {
        _samples[_position] = _samples[_position-1] + (_samples[_position] - _samples[_position - 1]) / _decay;
    }
    float sample = _samples[_position];
    
    _samples_played++;
    _position++;
    return sample;
}