/* 
 * libmbed-synth An audio synthesis library capable of running
 * alongside other activities. 
 * Copyright (C) <2009> Michael Sheldon <mike@mikeasoft.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
*/

#ifndef MBED_INSTRUMENT_H
#define MBED_INSTRUMENT_H

#include "Note.h"

class Instrument {

    public:
        Instrument();
        void note(Note note);
        void set_samplerate(int samplerate);
        void set_bpm(int bpm);
        float proc_sample();
        
    protected:
        float *_samples;
        int _num_samples;
        int _position;
        int _samplerate;
        int _bpm;
        int _duration;
        int _samples_played;
};

#endif