#include "mbed.h"
#include "Graphics.h"
#include "Cuboid.h"
#include "TrimeshObject.h"
#include "TieFighter.h"
#include "PluckedGuitar.h"
#include "Synth.h"

Graphics g(5, 6, 7, 8, 9);
TrimeshObject tf(tie_fighter_vertices, tie_fighter_faces, TIE_FIGHTER_NUM_FACES);
Synth s(18);

void fly_me_to_the_moon(Synth *s) {
    //Fly me to the moon
    s->add_note(NOTE_C5, 1.5); 
    s->add_note(NOTE_B4, 0.5);
    s->add_note(NOTE_A4, 0.5);
    s->add_note(NOTE_G4, 0.5);
    
    s->add_note(NOTE_F4, 1.5);
    s->add_note(NOTE_G4, 0.5);
    s->add_note(NOTE_A4, 0.5);
    s->add_note(NOTE_C5, 0.5);
    
    s->add_note(NOTE_B4, 1.5);
    s->add_note(NOTE_A4, 0.5);
    s->add_note(NOTE_G4, 0.5);
    s->add_note(NOTE_F4, 0.5);
    
    s->add_note(NOTE_E4, 3);
    
    s->add_note(NOTE_A4, 1.5);
    s->add_note(NOTE_G4, 0.5);
    s->add_note(NOTE_F4, 0.5);
    s->add_note(NOTE_E4, 0.5);
    
    s->add_note(NOTE_D4, 1.5);
    s->add_note(NOTE_E4, 0.5);
    s->add_note(NOTE_F4, 0.5);
    s->add_note(NOTE_A4, 0.5);
    
    s->add_note(NOTE_A_FLAT4, 1.5);
    s->add_note(NOTE_F4, 0.5);
    s->add_note(NOTE_E4, 0.5);
    s->add_note(NOTE_D4, 0.5);
    
    s->add_note(NOTE_C4, 2);
    s->add_note(NOTE_C_SHARP4, 1);
    
    s->add_note(NOTE_D4, 0.5);
    s->add_note(NOTE_A4, 0.5);
    s->add_note(NOTE_A4, 3);
    s->add_note(NOTE_C5, 1);
    s->add_note(NOTE_B4, 1);
    
    s->add_note(NOTE_G4, 5);
    s->add_note(NOTE_B3, 1);
    
    s->add_note(NOTE_C4, 0.5);
    s->add_note(NOTE_F4, 0.5);
    s->add_note(NOTE_F4, 3);
    s->add_note(NOTE_A4, 1);
    s->add_note(NOTE_G4, 1);
    s->add_note(NOTE_F4, 1);
    s->add_note(NOTE_E4, 5);
    
    s->add_note(NOTE_C5, 1.5);
    s->add_note(NOTE_B4, 0.5);
    s->add_note(NOTE_A4, 0.5);
    s->add_note(NOTE_G4, 0.5);
    
    s->add_note(NOTE_F4, 1.5);
    s->add_note(NOTE_G4, 0.5);
    s->add_note(NOTE_A4, 0.5);
    s->add_note(NOTE_C5, 0.5);
    
    s->add_note(NOTE_B4, 1.5);
    s->add_note(NOTE_A4, 0.5);
    s->add_note(NOTE_G4, 0.5);
    s->add_note(NOTE_F4, 0.5);
    
    s->add_note(NOTE_E4, 3);
    
    s->add_note(NOTE_A4, 1.5);
    s->add_note(NOTE_G4, 0.5);
    s->add_note(NOTE_F4, 0.5);
    s->add_note(NOTE_E4, 0.5);
    
    s->add_note(NOTE_D4, 1.5);
    s->add_note(NOTE_E4, 0.5);
    s->add_note(NOTE_F4, 0.5);
    s->add_note(NOTE_G4, 0.5);
    
    s->add_note(NOTE_A_FLAT4, 1.5);
    s->add_note(NOTE_F4, 0.5);
    s->add_note(NOTE_E4, 0.5);
    s->add_note(NOTE_D4, 0.5);
    
    s->add_note(NOTE_C4, 2);
    s->add_note(NOTE_C_SHARP4, 1);
    
    s->add_note(NOTE_D4, 0.5);
    s->add_note(NOTE_A4, 0.5);
    s->add_note(NOTE_A4, 3);
    s->add_note(NOTE_C5, 1);
    s->add_note(NOTE_B4, 1);
    
    s->add_note(NOTE_G4, 5);
    s->add_note(NOTE_A_FLAT4, 1);
    
    s->add_note(NOTE_A4, 0.5);
    s->add_note(NOTE_C4, 0.5);
    s->add_note(NOTE_C4, 3);
    s->add_note(NOTE_C4, 1);
    s->add_note(NOTE_D4, 1);
    
    s->add_note(NOTE_C4, 3);
}


int main() {
    double rotx = 0, roty = 0, rotz = 0;
    PluckedGuitar *guitar = new PluckedGuitar();
    s.set_bpm(100);
    s.set_instrument(guitar);
    fly_me_to_the_moon(&s);
    s.play();

    while (1) {
        rotx += 0.1;
        roty += 0.08;
        rotz += 0.05;
        
        tf.rotate(rotx, roty, rotz);
        tf.colour(0xffffff);
        tf.render(g);
        wait(0.02);
        g.fill(40, 40, 52, 52, 0x000000);
    }
}
