#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
#include "rgb-led.h"
#include "wave_player.h"
#include <string>
using namespace std;

Mutex stdio_mutex;
uLCD_4DGL uLCD(p28, p27, p29);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
AnalogOut DACout(p18);
wave_player waver(&DACout);
RGBLed myRGBled(p21, p22, p23);
Serial pc(USBTX, USBRX);
    Thread t2;
    Thread t3;
    Thread t4;
string color;


void lightsULCD() {
    while(1) {
        stdio_mutex.lock();
        uLCD.locate(3,4);
        uLCD.puts("Color of Led:          ");
        if (color == "red") {
            uLCD.puts("Color of LED: red");
        }
        if (color == "blue") {
            uLCD.puts("Color of LED: blue");
        }
        if (color == "green") {
            uLCD.puts("Color of LED: green");
        }
    
        stdio_mutex.unlock();
        pc.printf("Hello from thread1\n");
        Thread::wait(1000);
    }
}

void timeULCD() {
    int count = 0;
    while(1) {
        stdio_mutex.lock();
        if(count%3==0){
            uLCD.locate(3,8);
            uLCD.puts("Ah, ha, ha, ha");
        }
        else if(count%3==1){
            uLCD.locate(3,8);
            uLCD.puts("Stayin' Alive");
        }
        else {
            uLCD.locate(3,8);
            uLCD.puts("Stayin' Alive");
        }
        count++; 
        stdio_mutex.unlock();
                pc.printf("Hello from thread2\n");

        Thread::wait(1000);
    }

}

void playSound() {
    while(1) {
        FILE *wave_file;
        printf("\n\n\nHello, wave world!\n");
        wave_file=fopen("/sd/stayin.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
                pc.printf("Hello from thread3\n");

        Thread::wait(1000);
    }
}
    

int main() {


    t2.start(lightsULCD);
    t3.start(timeULCD);
    t4.start(playSound);
    pc.printf("hello\n");
    //test_thread((void *)"Th 1");
    while(1) {
                pc.printf("Hello from thread4\n");

        myRGBled.write(1.0,0.0,0.0); //red
        color = "red";
        wait(2.0);
        myRGBled.write(0.0,1.0,0.0); //green
        color = "green";
        wait(2.0);
        myRGBled.write(0.0,0.0,1.0); //blue
        color = "blue";
        wait(2.0);
        Thread::wait(1000);
    }
}
