#include "mbed.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
#include "wave_player.h"
#include "Joystick.h"
 
 
Nav_Switch myNav( p25, p22, p23, p21, p24); // U, D, L, R, Fire
uLCD_4DGL uLCD(p28, p27, p29);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
AnalogOut DACout(p18);
wave_player waver(&DACout);
 
int arrowVec[20];
int arrow;
int correct;
 
void mainMenu() {
    uLCD.baudrate(BAUD_3000000);
    while(1){
        uLCD.text_string("Simon Says", 4, 3, FONT_12X16, BLUE);
        uLCD.locate(6,8);
        uLCD.puts("Start");
        if(myNav.fire()) {
            uLCD.cls();
            return;
        }
    }
}

void createArrows(int lev) {
 
    for (int i = 0; i < lev; i++) {
        if (arrowVec[i] == 1) {
            uLCD.cls();
            uLCD.printf("     Level %d", lev); 
            uLCD.text_string("LEFT", 7, 14, FONT_12X16, RED);
            uLCD.triangle(25, 60, 55, 40, 55, 80, RED);
            uLCD.line(55, 50 , 55, 70, BLACK);
            uLCD.rectangle(55,50,95,70,RED);
            uLCD.line(55, 50 , 55, 70, BLACK);
            //wait(.2);
        } else if (arrowVec[i] == 2) {
            uLCD.cls();
            uLCD.printf("     Level %d", lev); 
            uLCD.text_string("RIGHT", 6, 14, FONT_12X16, BLUE);
            uLCD.triangle(95, 60, 65, 40, 65, 80, BLUE);
            uLCD.line(65, 50 , 65, 70, BLACK);
            uLCD.rectangle(25,50,65,70,BLUE); 
            uLCD.line(65, 50 , 65, 70, BLACK);  
        } else if (arrowVec[i] == 3) {
            uLCD.cls();
            uLCD.printf("     Level %d", lev); 
            uLCD.text_string("UP", 8, 14, FONT_12X16, GREEN);
            uLCD.triangle(44, 55, 84, 55, 64, 25, GREEN);
            uLCD.line(54, 55 , 74, 55, BLACK);
            uLCD.rectangle(54, 55, 74, 95,GREEN);
            uLCD.line(54, 55 , 74, 55, BLACK);
        } else {
            uLCD.cls();
            uLCD.printf("     Level %d", lev); 
            uLCD.text_string("DOWN", 7, 14, FONT_12X16, WHITE);
            uLCD.triangle(44, 65, 84, 65, 64, 95, WHITE);
            uLCD.line(54, 65, 74, 65, BLACK);
            uLCD.rectangle(54, 25, 74, 65,WHITE);
            uLCD.line(54, 65, 74, 65, BLACK);
        }
        wait(0.5);
    }
}

void beep() {
    FILE *wave_file;
    wave_file=fopen("/sd/wavfiles/chime.wav","r");
    waver.play(wave_file);
    fclose(wave_file); 
 }
 
void buzz() {
    FILE *wave_file;
    wave_file=fopen("/sd/wavfiles/buzzer.wav","r");
    waver.play(wave_file);
    fclose(wave_file); 
}
 
 
void inputScreen() {
    uLCD.text_string("Input your answer", 1, 1, FONT_12X16, WHITE);
}

void endGame(int level) {
        uLCD.cls();
        uLCD.text_string("Game Over", 5, 1, FONT_12X16, BLUE);
        uLCD.locate(1,5);
        uLCD.puts("You got to level");
        uLCD.locate(8,7);
        uLCD.printf("%d", level);
        uLCD.text_string("Fire to Restart", 2, 11, FONT_12X16, GREEN);
        while(1) {
            if(myNav.fire()) {
                uLCD.cls();
                return;
            }
        } 
}
 
int main() {
      bool game = true;
    int level = 0;
    //int arrowVec[20]; 
    mainMenu();
    
    
    while(game) {
        level++;
        
        for (int i = 0; i < level; i++) {
            arrow = (rand() % 4) + 1;
            arrowVec[i] = arrow;
        }
        
        createArrows(level);
        uLCD.cls();
        inputScreen();
        
        for (int j = 0; j < level; j++) {
            int decision = 0;
            while (decision == 0) {
                if(myNav.fire()){
                }
                else if(myNav.left()) {
                    decision = 1;
                    if(arrowVec[j]==1) {
                        correct = 1;
                        beep();
                    } else {
                        correct = 2; // Game should end
                        buzz();
                    }
                }

                else if(myNav.right()) {
                    decision = 1;
                    if(arrowVec[j]==2) {
                        correct = 1;
                        beep();
                    } else {
                        correct = 2;
                        buzz();
                    }
                }


                else if(myNav.up()) {
                    decision = 1;
                    if(arrowVec[j]==3) {
                        correct = 1;
                        beep();
                    } else {
                        correct = 2;
                        buzz();
                    }
                }


                else if(myNav.down()) {
                    decision = 1;
                    if(arrowVec[j]==4) {
                        correct = 1;
                        beep();
                    } else {
                        correct = 2;
                        buzz();
                    }
                }

                if (correct==2){
                    // end game
                    game = false;
                    endGame(level);
                    game = true;
                    level = 0;
                    correct = 0;
                }
            }
        }
        if(level==21){
            game = false;
            endGame(level);
            level = 0;
            game = true;
            correct = 0;
        }    
    }
    

}