#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
#include "rgb-led.h"
#include "wave_player.h"
#include <string>

using namespace std;

Mutex stdio_mutex;
uLCD_4DGL uLCD(p28, p27, p29);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
AnalogOut DACout(p18);
wave_player waver(&DACout);
RGBLed myRGBled(p21, p22, p23);
Serial pc(USBTX, USBRX);

BusOut myled(LED1,LED2,LED3,LED4);
Serial bluemod(p13 ,p14);
PwmOut red(p21);
PwmOut green(p22);
PwmOut blue(p23);

    Thread t2;
    Thread t3;
    Thread t4;
string color;


void lightsULCD() {
    while(1) {
        stdio_mutex.lock();
        uLCD.locate(3,4);
        uLCD.puts("Color of Led:          ");
        if (color == "red") {
            uLCD.puts("Color of LED: red");
        }
        if (color == "blue") {
            uLCD.puts("Color of LED: blue");
        }
        if (color == "green") {
            uLCD.puts("Color of LED: green");
        }
    
        stdio_mutex.unlock();
        pc.printf("Hello from thread1\n");
        Thread::wait(1000);
    }
}

void timeULCD() {
    int count = 0;
    while(1) {
        stdio_mutex.lock();
        if(count%3==0){
            uLCD.locate(3,8);
            uLCD.puts("Ah, ha, ha, ha");
        }
        else if(count%3==1){
            uLCD.locate(3,8);
            uLCD.puts("Stayin' Alive");
        }
        else {
            uLCD.locate(3,8);
            uLCD.puts("Stayin' Alive");
        }
        count++; 
        stdio_mutex.unlock();
                pc.printf("Hello from thread2\n");

        Thread::wait(1000);
    }

}

void playSound() {
//    char bnum=0;
//    while(1) {
//        FILE *wave_file;
//        stdio_mutex.lock();
//        if (bluemod.getc()=='!') {
//            if (bluemod.getc()=='B') { //button data
//                bnum = bluemod.getc(); //button number
//                if ((bnum=='1')) { //is a number button 1..4
//                    wave_file=fopen("/sd/stayin.wav","r");
//                    waver.play(wave_file);
//                    fclose(wave_file);
//                } else if (bnum == '2'){
//                    wave_file=fopen("/sd/disco.wav","r");
//                    waver.play(wave_file);
//                    fclose(wave_file);
//                }
//            }
//        }
//        stdio_mutex.unlock();

        Thread::wait(1000);
  //  }
}
    

int main() {


    t2.start(lightsULCD);
    t3.start(timeULCD);
    t4.start(playSound);
    pc.printf("hello\n");
    //test_thread((void *)"Th 1");
    
    char bred=0;
    char bgreen=0;
    char bblue=0;
    red = green = blue = 0;
    while(1) {
        stdio_mutex.lock();
        if (bluemod.getc()=='!') {
            if (bluemod.getc()=='C') { //color data packet
                bred = bluemod.getc(); // RGB color values
                bgreen = bluemod.getc();
                bblue = bluemod.getc();
                if (bluemod.getc()==char(~('!' + 'C' + bred + bgreen + bblue))) { //checksum OK?
                    red = bred/255.0; //send new color to RGB LED PWM outputs
                    green = bgreen/255.0;
                    blue = bblue/255.0;
                }
            }
        }
        stdio_mutex.unlock();
        Thread::wait(1000);
    }
}

