/*
MicroBitBuggy

A program that uses the MicroBit to control the movement of a small buggy.

Copyright (c) 2016 Elijah Orr

Permission is hereby granted, free of charge, to any person obtaining a copy 
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights 
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell    
copies of the Software, and to permit persons to whom the Software is        
furnished to do so, subject to the following conditions:                     
                                                                             
The above copyright notice and this permission notice shall be included in   
all copies or substantial portions of the Software.                          
                                                                             
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR   
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,     
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE  
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER       
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN    
THE SOFTWARE. 

*/

#include "MicroBit.h"
#include "buggy_functions.h"  //"buggy_functions.h" contains the functions that we will use to move the buggy

/* The basic functions available are:
*    
*    forward(time);
*    left(time);
*    right(time);
*    hold(time);
*
* see buggy_functions.h for a full list.
*/ 

int main() //int main is run automatically. Place your program here
{
    stop();
    while(1){
        forward(6); //move the buggy forward for 10 seconds
        right(8);
        forward(5);
        left(2);
    }
} 