/*********************************************************
*buggy_functions.h                                       *
*Author: Elijah Orr & Dan Argust                         *
*                                                        *
*A library of functions that can be used to control a    *
*buggy using the BBC MicroBit                            *
*********************************************************/

/* include guards are used to prevent problems caused by 
multiple definitions */
#ifndef BUGGY_FUNCTIONS_H
#define BUGGY_FUNCTIONS_H

/* MicroBit.h must be included in this file also */
#include "MicroBit.h"

/* these are function prototypes that declare all the functions
in the library.*/
extern void forward(float); //Move the buggy forward for (float) seconds
extern void left(float); //Turn left for (float) seconds
extern void right(float); //Turn right for (float) seconds
extern void hold(float); //Hold the buggy in an idle state for (float) seconds
extern void stop(); //Stop all motors

#endif // BUGGY_FUNCTIONS_H