#ifndef SIMPLEGUI_TEXT_WIDGET_H
#define SIMPLEGUI_TEXT_WIDGET_H

#include "Widget.h"
#include "Font.h"
#include "FontRenderer.h"

class TextWidget : public Widget
{

public:

    enum VAlign { TOP, MIDDLE, BOTTOM };
    enum HAlign { LEFT, CENTRE, RIGHT };

    TextWidget(GraphicsContext *context);
    TextWidget(GraphicsContext *context, FontRenderer* renderer);
    TextWidget(GraphicsContext *context, FontRenderer* renderer, Font* font);

    /**************************
    * Custom methods of this class
    **************************/
    virtual void setFont(Font* font);
    virtual void setText(char* text);
    virtual void setHAlign(HAlign alignment);
    virtual void setVAlign(VAlign alignment);
    
    virtual Font *getFont();

protected:

    /**************************
    * Overrides of Widget
    **************************/
    virtual void _draw();

    /**************************
    * Custom data of this class
    **************************/
    char* _text;
    FontRenderer* _renderer;
    Font* _font;
    HAlign _halign;
    VAlign _valign;
};

#endif