#include "UGFontRenderer.h"
#include "Arial24x23.h"

UGFontRenderer::UGFontRenderer() : FontRenderer() 
{
}

void UGFontRenderer::putc(const char  c, GraphicsDisplay* display, Font* font)
{

    UGFont* _font = (UGFont*) font;
    if(!_font->contains(c)) {
        return;
    }
    
    uint8_t cw = _font->zoomedWidthOf(c);
    uint8_t ch = _font->zoomedHeight();

    bool wrap = (_cx + cw) > _wx1 && !_clip;
    
    if(c == '\n' || wrap) {
        _cx = _wx0;
        _cy += ch;
    }
    
    if(cw == 0) {
        return;
    }
    
    // We have to do clipping/wrapping for now because the display doesn't do it for us
    if((_cx + cw) > _wx1) {
        // We've done any wrapping already, so if we get here the window must be smaller than the character
        return;
    }
    
    if((_cy + ch) > _wy1) {
        return;
    }
        

    uint8_t height = _font->height();
    uint8_t width = _font->widthOf(c);
    uint8_t zx = _font->zoomX();
    uint8_t zy = _font->zoomY();
    uint8_t bpc = _font->bytesPerCol();
    uint8_t row, col, v;
    uint8_t bits, mask;

    // We don't do clipping logic for chars - that's the job of the display
    // Just set a window into which to render the char and let the display ignore it if it doesn't fit
    display->window(_cx, _cy, cw, ch);

    uint8_t* glyphData = _font->getGlyphData(c);

    // construct the char into the buffer
    for (row=0; row < height; row++) {  //  vert line
        for (v=0; v < zy; v++) { // repeat horiz line for vertical zooming
            for (col=0; col < width; col++) {   //  horz line

                bits =  glyphData[(bpc * col) + (row >> 3)];

                mask = 1 << (row & 0x07);

                if (bits & mask) {
                    display->window_pushpixel(_foreground, zx);
                } else {
                    display->window_pushpixel(_background, zx);
                }
            }
        } //for each zoomed vert
    }
    _cx += cw;
}

void UGFontRenderer::puts(const char*  c, GraphicsDisplay* display, Font* _font)
{}