#ifndef SIMPLEGUI_EVENT_HANDLER_H
#define SIMPLEGUI_EVENT_HANDLER_H

#include "Event.h"
#include "EventHandlerFunction.h"

class EventHandler {
    
    public:

    EventHandler(EventType eventType, EventHandlerFunction fn) : type(eventType)
    {
        _fp.attach(fn);
    }
    
    
    template<typename T>
    EventHandler(EventType eventType, T* tptr, void (T::*mptr)(Event)) : type(eventType)
    {
        _fp.attach(tptr, mptr);
    }
    
    void handle(Event e) {
        _fp.call(e);
    }
    
    EventType type;
    FunctionPointerArg1<void,Event> _fp;
};

class EventHandlerList {
    
    public:
    
    EventHandlerList(EventHandler* eventHandler) : handler(eventHandler), next(NULL), prev(NULL)
    {
    }
    
    EventHandler *handler;
    EventHandlerList *next;
    EventHandlerList *prev;

};

#endif