#include "ContainerWidget.h"

ContainerWidget::ContainerWidget(GraphicsContext *context)
    :
    Window(context), _layout(HORIZONTAL)
{
}

void ContainerWidget::setLayout(Layout l)
{
    if(_layout != l) {
        _layout = l;
        damage();
    }
}

void ContainerWidget::setSize(int width, int height)
{
    if(_minWidth != width || _minHeight != height) {
        _minWidth = width;
        _minHeight = height;
        damage();
    }
    Window::setSize(width, height);
}

void ContainerWidget::attach(Widget *child)
{
    Window::attach(child);
    if(_layout == FIXED) {
        // Re-interpret child's location referenced to the container
        child->setOffset(x(), y());
    }
}

void ContainerWidget::_adjust()
{
    setSize(_minWidth, _minHeight);
    Window::_adjust();

    int wx = _inner.x;
    int wy = _inner.y;
    int width = 0;
    int height = 0;



    Widget *w;

    _widgets.reset();

    while((w = _widgets.next()) != NULL) {

        if(_layout == FIXED) {
            w->setOffset(wx, wy);
        } else {

            // Position the widgets
            w->setLocation(wx, wy);

            if(_layout == HORIZONTAL) {
                wx += w->width();
                if(w->height() > height) {
                    height = w->height();
                }
            } else {
                wy += w->height();
                if(w->width() > width) {
                    width = w->width();
                }
            }
        }
    }

    if(_layout != FIXED) {

        int neededWidth;
        int neededHeight;

        if(_layout == HORIZONTAL) {
            neededWidth = _padding + _borderWidth + wx - _outer.x;
            neededHeight = 2 * (_padding + _borderWidth) + height;
        } else {
            neededWidth = 2 * (_padding + _borderWidth) + width;
            neededHeight = _padding + _borderWidth + wy - _outer.y;
        }

        if(neededWidth > _outer.width) {
            setWidth(neededWidth);
        }

        if(neededHeight > _outer.height) {
            setHeight(neededHeight);
        }

        if(_layout == VERTICAL_CENTER) {
            // layout again to center the widgets
            int center = (_outer.width/2) + _outer.x;
            _widgets.reset();
            while((w = _widgets.next()) != NULL) {
                w->setLocation(center - (w->width() / 2), w->y());
            }
        }
    }

    Window::_adjust();
}
