#include "FastFontRenderer.h"

FastFontRenderer::FastFontRenderer() : FontRenderer()
{
}

void FastFontRenderer::putc(const char  c, GraphicsDisplay* display, Font* font)
{
    FastFont* _font = (FastFont*)font;
    uint8_t ch = _font->zoomedHeight();

    if(c == '\n') {
        _cx = _wx0;
        _cy += ch;
        return;
    }

    if(!_font->contains(c)) {
        return;
    }

    uint8_t cw = _font->zoomedWidthOf(c);
    
    if((_cx + cw) > _wx1 && !_clip) {
        _cx = _wx0;
        _cy += ch;
    }

    if(cw == 0 || (_cx + cw) > _wx1 || (_cy + ch) > _wy1) {
        return;
    }

    uint8_t height = _font->height();
    uint8_t width = _font->widthOf(c);
    uint8_t zx = _font->zoomX();
    uint8_t zy = _font->zoomY();
    uint8_t bytesPerRow = _font->bytesPerRow();
    uint8_t bytesPerGlyph = _font->totalBytesPerGlyph();
    uint8_t row, z, rowByte, mask, bits;
    uint8_t* glyph = _font->glyph(c);
    int rowIndex = 0;
    int byteIndex, bitsToRender;

    display->window(_cx, _cy, cw + zx, ch);

    for(row=0; row<height; row++) {
        // repeat for zoom
        for(z=0; z < zy; z++) {
            byteIndex = rowIndex;
            bitsToRender = width;
            for(rowByte = 0; rowByte < bytesPerRow; rowByte++) {
                bits = glyph[byteIndex++];
                mask = 0x80;
                while(mask != 0 && bitsToRender != 0) {

                    if(bits & mask) {
                        display->window_pushpixel(_foreground, zx);
                    } else {
                        display->window_pushpixel(_background, zx);
                    }

                    mask = mask >> 1;
                    bitsToRender--;
                }
            }
            // Add a one-pixel (zoomed) space
            display->window_pushpixel(_background, zx);
        }
        rowIndex += bytesPerRow;
    }

    _cx += cw;
}

void FastFontRenderer::puts(const char* str, GraphicsDisplay* display, Font* font)
{

    FastFont* _font = (FastFont*)font;
    uint8_t cw;
    uint8_t ch = _font->zoomedHeight();
    uint8_t height = _font->height();
    uint8_t zoomX = _font->zoomX();
    uint8_t zoomY = _font->zoomY();
    uint8_t bytesPerRow = _font->bytesPerRow();
    uint8_t bytesPerGlyph = _font->totalBytesPerGlyph();

    // Render the text line by line
    // Iterate to build up the length of the first line so we can
    // set a clipping window
    const char* line = str;

    while(*line != NULL) {
        
        if((_cy + ch) > _wy1) {
            return;
        }
        
        // If the first char is a \n, just increment cy
        if(*line == '\n') {
            line++;
            _cy += ch;
            continue;
        }
        
        // Figure out how wide the line is. Clip characters outside the bounding box
        int lw = 0;
        const char* cur = line;
        const char* printable = line;
        int nChars = 0;
        bool wrapped = false;

        while(*cur != NULL && *cur != '\n') {

            cw = _font->zoomedWidthOf(*cur);

            if((lw + cw) < (_wx1 - _wx0)) {
                lw += cw + zoomX;
                nChars++;
                cur++;
            } else {
                // dump the rest of the line up to the end or the next newline (clipping)
                if(_clip) {
                    while(*cur != NULL && *cur != '\n') {
                        cur++;
                    }
                } else {
                    wrapped = true;
                }
                break;
            }
        }

        // Set a wrapping window for the entire line
        display->window(_wx0, _cy, lw, ch);

        int rowIndex = 0;
        // Do as many lines as a char is pixels high * zoomY
        for(int row=0; row<height; row++) {
            for(int zy=0; zy<zoomY; zy++) {
                for(int i=0; i<nChars; i++) {
                    // print all the bits in this char for the current row
                    // taking zoomX into account
                    char c = printable[i];
                    uint8_t* glyph = _font->glyph(c);
                    uint8_t bitsToRender = _font->widthOf(c);
                    for(int col=0; col<bytesPerRow; col++) {
                        uint8_t bits = glyph[rowIndex + col];
                        uint8_t mask = 0x80;
                        while(mask && bitsToRender) {
                            if(bits & mask) {
                                display->window_pushpixel(_foreground, zoomX);
                            } else {
                                display->window_pushpixel(_background, zoomX);
                            }
                            mask = mask >> 1;
                            bitsToRender--;
                        }
                    }
                    // Add a one-pixel (zoomed) space
                    display->window_pushpixel(_background, zoomX);

                }
            }
            rowIndex += bytesPerRow;
        }
       if(wrapped) _cy += ch;
        line = cur;
    }
}
