#include "OKCancelDialog.h"
#include "BitmapWidget.h"
#include "GreenTick_64x64_bmp.h"
#include "RedCross_64x64_bmp.h"

OKCancelDialog::OKCancelDialog(GraphicsContext *context) : ContainerWidget(context)
{

    setLayout(FIXED);
    setSize(
        context->display()->width(),
        context->display()->height()
    );


    BitmapWidget *apply = new BitmapWidget(context);
    apply->setBitmap(GreenTick_64x64_bmp, 64, 64);
    apply->setLocation(
        0,
        context->display()->height() - apply->height()
    );
    attach(apply);

    BitmapWidget *cancel = new BitmapWidget(context);
    cancel->setBitmap(RedCross_64x64_bmp, 64, 64);
    cancel->setLocation(
        context->display()->width() - cancel->width(),
        context->display()->height() - cancel->height()
    );
    attach(cancel);
    
    EventHandler *ok = new EventHandler(TOUCH_TAP, this, &OKCancelDialog::_handleOK);
    EventHandler *cancelled = new EventHandler(TOUCH_TAP, this, &OKCancelDialog::_handleCancel);
    apply->setEventHandler(ok);
    cancel->setEventHandler(cancelled);
}


void OKCancelDialog::_handleOK(Event e) {
    _onOK.call(e);
}

void OKCancelDialog::_handleCancel(Event e) {
    _onCancel.call(e);
}