#ifndef SIMPLEGUI_WINDOW_H
#define SIMPLEGUI_WINDOW_H

/**
* Defines an interface for classes which can contain widgets
**/

class Window;

#include "Widget.h"
#include "GraphicsContext.h"
#include "LinkedList.h"

class Window : public Widget {
    
public:
    
    Window(GraphicsContext *context);
    
    /**
    * We are going to override these Widget methods
    **/
    virtual void attach(Widget *widget);
    virtual void detach(Widget *widget);   
    virtual void dirtyAll();
    
    virtual void handleEvent(Event e);
    virtual void _reenumerateHandledEvents();
    virtual uint16_t _getHandledEvents();
    
protected:

    /**
    * Override to draw all the children
    **/
    virtual void _draw();

    LinkedList<Widget> _widgets;
    uint16_t _childHandledEvents;
    
    void _dirtyIntersected(Widget *w);
};

#endif