#ifndef SIMPLEGUI_BITMAP_WIDGET_H
#define SIMPLEGUI_BITMAP_WIDGET_H

#include "Widget.h"

class BitmapWidget : public Widget {
    
    public:
    
        BitmapWidget(GraphicsContext *context);
        BitmapWidget(GraphicsContext *context, bool monochrome);
                
        // Ccncrete methods for this class
        void setBitmap(unsigned char const * bitmap, int width, int height);
        
        // Set to draw the bitmap in monochrome
        void setMonochrome(bool enabled);
        bool isMonochrome();
        
        // Override to accommodate auto-resizing (yes, yes. sorry)
        virtual void setBorder(int width, uint16_t color);
    
    protected:

        virtual void _draw();      
            
        unsigned char* _bitmap;
        bool _monochrome;
        int _bitmapWidth, _bitmapHeight;
};

#endif