#include "EventDispatcher.h"

EventDispatcher::EventDispatcher() {
}

void EventDispatcher::attachListener(EventListener* l) {
    _listeners.appendOnce(l);
}

void EventDispatcher::detachListener(EventListener* l) {
    _listeners.remove(l);
}

void EventDispatcher::dispatchEvent(Event e) {
    EventListener* l;
    _listeners.reset();
    while((l=_listeners.next()) != NULL) {
        l->handleEvent(e);
    }
}

void EventDispatcher::queueEvent(const Event e)
{
    Event* qe = _mailbox.alloc();
    qe->type = e.type;
    qe->target = e.target;
    qe->screenX = e.screenX;
    qe->screenY = e.screenY;
    _mailbox.put(qe);
}

void EventDispatcher::pumpEvents()
{

    osEvent oe = _mailbox.get(1);

    if(oe.status == osEventMail) {

        Event* qe = (Event*)oe.value.p;
        Event e;
        e.target = qe->target;
        e.type = qe->type;
        e.screenX = qe->screenX;
        e.screenY = qe->screenY;

        dispatchEvent(e);
        _mailbox.free(qe);
    }
}
