//this file is for all the global functions that I need to use
//but are here, so they are not cluttering up main.cpp
#include "functions.h"

//this uses Timer 0, but we could just as easily change it to Timer 1, 2 or 3
void wait(float time) //seconds
{
    uint32_t us = time * 1000000; //microseconds

    uint8_t pclk;
    uint32_t pclkdiv = (LPC_SC->PCLKSEL0 >> 2) & 0x03;

    switch ( pclkdiv ) // table 42 (page 57 in user manual)
    {
      case 0x00:
      default:
            pclk = 4;
            break;
      case 0x01:
            pclk = 1;
            break;
      case 0x02:
            pclk = 2;
            break;
      case 0x03:
            pclk = 8;
            break;
    }

    LPC_TIM0->TCR = 0x02;           /* reset timer */
    LPC_TIM0->PR  = (SystemCoreClock / (pclk * 1000000));
    LPC_TIM0->MR0 = us;             /* enter delay time */
    LPC_TIM0->IR  = 0xff;           /* reset all interrrupts */
    LPC_TIM0->MCR = 0x04;           /* stop timer on match */
    LPC_TIM0->TCR = 0x01;           /* start timer */

    /* wait until delay time has elapsed */
    while (LPC_TIM0->TCR & 0x01);
}