#ifndef __TICKER_H_
#define __TICKER_H_

#include "LPC17xx.h"
//#include "cmsis_nvic.h"
//old way: NVIC_SetVector(TIMER2_IRQn, funcaddr); //tell it to run this function


/**
 * @author Jason Garner
 *
 * <b>Ticker</b> is an alternative implementation of the Mbed library <a href="/handbook/Ticker">Ticker</a> to save memory.
 * The maximum number of Ticker instances is fully customizable. 
 *
 */
class Ticker
{
    void initTimer2(); // the constructor initializes the hardware timer, if it wasn't already initialized
public:
    static bool timer2initialized; //stores whether the timer has been initialized
    static Ticker** tickers; //array of pointers to ticker instances
    uint32_t func; //function that NVIC will call on interrupts
    uint32_t interval; // unit interval to execute func (unit = 100 microseconds)
    uint32_t remaining; // units remaning until executing func (unit = 100 microseconds)
    static int active_tickers; //how many instances of this class we have that are attached. (NVIC needs this)
    static int MAX; // max size of Ticker* array
    bool active; // whether or not the instance is an active Ticker 
    bool timeout; // if set to true, this is effectively a Timeout object now. (it detaches after the next function call)
     /**
     * Regular constructor: the default internal array size is 5.
     */  
    Ticker();

     /**
     * Custom constructor: initializes the object with the specified parameter.
     *
     * @param max Maximum instances of Ticker objects allowed. (sets internal array size of Ticker* to instances)
     */  
    Ticker(int);
    
    ~Ticker(); //DESTRUCTOR   
    
     /**
     * Attach a function to be called by the Ticker, specifiying the interval in seconds. 
     * The timer is a 32bit 100 microsecond Timer, so the smallest time is 100 microseconds and the largest time is about 59 hours. 
     *
     * @param fptr pointer to the function to be called 
     * @param t The time in seconds in between function calls.
     */  
    void attach(void (*fptr)(void), float t); //address of function to call, and interval to call it
    
     /**
     * Detaches the function from the Ticker. The function will no longer be called, and a new one can now be attached.
     */  
    void detach(); //removes address from ticker array
};

#endif