#include "Serial.h"

void Serial::initUART0()
{
    int pclk;
    unsigned long int Fdiv;

    // PCLK_UART0 is being set to 1/4 of SystemCoreClock
    pclk = SystemCoreClock / 4;     
    
    // Turn on power to UART0
    LPC_SC->PCONP |=  (1 << 3);
            
    // Turn on UART0 peripheral clock
    LPC_SC->PCLKSEL0 &= ~(3 << 6); // mask
    LPC_SC->PCLKSEL0 |=  (0 << 6);         // PCLK_periph = CCLK/4 ,, 6 is pclk for uart0
    
    // Set PINSEL0 so that P0.2 = TXD0, P0.3 = RXD0
    LPC_PINCON->PINSEL0 &= ~0xf0;
    LPC_PINCON->PINSEL0 |= ((1 << 4) | (1 << 6));
    
    LPC_UART0->LCR = 0x83;          // 8 bits, no Parity, 1 Stop bit, DLAB=1
    Fdiv = ( pclk / 16 ) / baudrate ;   // Set baud rate
    LPC_UART0->DLM = Fdiv / 256;                                                        
    LPC_UART0->DLL = Fdiv % 256;
    LPC_UART0->LCR = 0x03;              // 8 bits, no Parity, 1 Stop bit DLAB = 0
    LPC_UART0->FCR = 0x07;              // Enable and reset TX and RX FIFO
}

Serial::Serial()
{
    baudrate = 9600;
    initUART0();
}

Serial::Serial(int br)
{
    baudrate = br;
    initUART0();
}

void Serial::putc(char c)
{
    while( !(LPC_UART0->LSR & 0x20) );      // Block until tx empty
    
    LPC_UART0->THR = c;
}

char Serial::getc()
{
    char c;
    while( !(LPC_UART0->LSR & 0x01) );  // wait until something received   
    c = LPC_UART0->RBR; // Read Receiver buffer register
    return c;
}

void Serial::printf(char* sendstring)
{
    int i = 0;
    // loop through until reach string's zero terminator
    while (sendstring[i] != '\0')
    {
            putc(sendstring[i]); // print each character
            i++;
    }
}

void Serial::printf(double number)
{
    int numberAsInt = number; //truncates right of decimal point
    printf(numberAsInt);
    putc('.');
    int rightOfDecimal = (number-numberAsInt)*1000000000; //truncating smaller than 10^(-9)
    printf(rightOfDecimal);
}

void Serial::printf(double number, int res)
{
    int numberAsInt = number; //truncates right of decimal point
    printf(numberAsInt);
    putc('.');
    int rightOfDecimal = (number-numberAsInt)*res;
    printf(rightOfDecimal);
}

void Serial::printf(int number)
{
    //we go from left to right
    int numofdigits = 0;
    int temp2 = number;
    while(temp2 > 0)
    {
        numofdigits = numofdigits + 1;
        temp2 = temp2 / 10;
    } 
    
    while(numofdigits > 0)
    {
        int temp = numofdigits;
        int position = 1;
        while(temp > 1)
        {
            position = position * 10;
            temp = temp - 1;
        }
        
        int digit = (number / position) % 10;
        
        char character = tochar(digit);
        putc(character);
        numofdigits = numofdigits - 1; //
    }    
}

// converts an individual digit into a character
char Serial::tochar(int digit)
{
    int character = '0';
    switch (digit)
    {
    case 0 :
        character = '0';
        break;
    case 1 :
        character = '1';
        break;
    case 2 :
        character = '2';
        break;
    case 3 :
        character = '3';
        break;
    case 4 :
        character = '4';
        break;
    case 5 :
        character = '5';
        break;
    case 6 :
        character = '6';
        break;
    case 7 :
        character = '7';
        break;
    case 8 :
        character = '8';
        break;
    case 9 :
        character = '9';
        break;
    }

    return character;
}
