#ifndef __INOUT_H_
#define __INOUT_H_

#include "LPC17xx.h"

//useful constants to define
#define PULLUP 0
#define PULLDOWN 1
#define PULLNONE 2
#define KEEPER 3
#define OUTPUT 1
#define INPUT 0
#define LED1 1
#define LED2 2
#define LED3 3
#define LED4 4
#define NULL 0

#define p5 5
#define p6 6
#define p7 7
#define p8 8
#define p9 9
#define p10 10
#define p11 11
#define p12 12
#define p13 13
#define p14 14
#define p15 15
#define p16 16
#define p17 17
#define p18 18
#define p19 19
#define p20 20
#define p21 21
#define p22 22
#define p23 23
#define p24 24
#define p25 25
#define p26 26
#define p27 27
#define p28 28
#define p29 29
#define p30 30

class InOut
{
public: // char type if value never goes above 256
    char port; //the port number (ports 0, 1 or 2)
    char bit; //the bit of the port
    void write(bool); //bool because it can only be high or low
    bool read(); //bool because it can only be high or low
    InOut(char, bool); //contructor for pins (led or mbed pin #, and 1 for output or 0 for input)
    InOut(char, char, bool); // port, bit and 1 for output / 0 for input. This is for the pins that the mbed doesn't use
    void setDirection(bool); // the constructor calls this method, but we can call it too if we need to
    void mode(char); // PULLUP, PULLDOWN, PULLNONE or KEEPER (char because really we are only using 2 bits)
    InOut& operator=(bool); // so we can do led1 = 0; instead of led1.write(0); just like the mbed library does
    operator bool(); // so we can do "led1" instead of "led1.read()" just like the mbed library does
    void output(); //calls setDirection, to set bit to output
    void input(); //calls setDirection, to set bit to input
};

#endif