#include "Ticker.h"
//This class uses Timer 2

extern "C" void TIMER2_IRQHandler(void)
{
  if ( LPC_TIM2->IR & 0x1 )
  {
    LPC_TIM2->IR = 0x1;              /* clear interrupt flag */
    for(char count = 0; count < Ticker::active_tickers; count++)
    {
        if((*(Ticker::tickers[count])).active)
        {
            if((*(Ticker::tickers[count])).remaining == 0)
            {
                //void (*func)(void) = (void (*)(void))((uint32_t)&isr);
                //func();
                (*(void (*)(void))((*(Ticker::tickers[count])).func))();
    
                if((*(Ticker::tickers[count])).timeout)
                    (*(Ticker::tickers[count])).active = false;
                else
                    (*(Ticker::tickers[count])).remaining = (*(Ticker::tickers[count])).interval - 1; //set up for next interval
            }
            else
            {
                (*(Ticker::tickers[count])).remaining = (*(Ticker::tickers[count])).remaining - 1;
            }       
        }
    }
  }
}

// static data initialization  (only called once)
bool Ticker::timer2initialized = false; 
int Ticker::active_tickers = 0;
int Ticker::MAX = 5;
Ticker** Ticker::tickers = 0; //NULL POINTER

void Ticker::initTimer2() 
{
    LPC_SC->PCLKSEL1 &= (3 << 12); //mask
    LPC_SC->PCLKSEL1 |= (1 << 12); //sets it to 1*SystemCoreClock - table 42 (page 57 in user manual)

    LPC_SC->PCONP |= (0x1<<22);     // turn on power for timer 2
    LPC_TIM2->TCR = 0x02;           // reset timer
    LPC_TIM2->PR  = (SystemCoreClock / 1000000); //microsecond steps
    LPC_TIM2->MR0 = 100;            // 100 microsecond interval interrupts
    LPC_TIM2->IR  = 0x3f;           // reset all interrrupts
    LPC_TIM2->MCR = 0x03;           // reset timer on match and generate interrupt (MR0)
    LPC_TIM2->TCR = 0x01;           // start timer
    
    NVIC_EnableIRQ(TIMER2_IRQn); // Enable the interrupt
    
    timer2initialized = true;
}

Ticker::Ticker()
{
    if(!timer2initialized)
    {
        initTimer2();
        tickers = new Ticker*[MAX];
    }
    active = false;
    timeout = false;
}

Ticker::Ticker(int maxsize)
{
    if(!timer2initialized)
    {
        initTimer2();
        tickers = new Ticker*[maxsize];
        MAX = maxsize;
    }
    active = false;
    timeout = false;
}

void Ticker::attach(void (*funcaddr)(void), float secinterval)
{
    if(active_tickers < MAX)
    {
        func = (uint32_t)funcaddr; //pointer to function address
        interval = secinterval*10000;
        remaining = secinterval*10000; // 100 microsecond resolution
        tickers[active_tickers] = this;
        active_tickers = active_tickers + 1;
        active = true;
    }
}

void Ticker::detach()
{
    active_tickers = active_tickers - 1;
    tickers[active_tickers] = 0; //NULL pointer
    active = false;
    timeout = false;
}

Ticker::~Ticker()
{
    if(active || timeout)
        detach();   
}