#include "registers.h"
DigitalOut led1(p20);
DigitalOut led2(p19);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalIn switch1(p21);

Serial pc(115200);
Timer t(1000); //ms resolution for a serial stopwatch demo

Timeout tock;
Ticker tock2;
Ticker tock3;

extern "C" void turnOff(void) {
    led1 = 0;
}

extern "C" void turnOn(void) {
    led1 = 1;
    tock.attach(&turnOff, 0.0001);
}

extern "C" void led2flip(void)
{
    led2 = !led2;
}

int main() {  //Timer and Ticker demonstration
    switch1.mode(PULLDOWN);
    t.start();
    tock2.attach(&turnOn, 0.005);
    tock3.attach(&led2flip, 0.0025);
    while(1)
    {
        double time = t;
        int h = 0;
        int m = 0;
        while(time > 3600)
        {
            time = time - 3600;
            h = h + 1;
        }
        while(time > 60)
        {
            time = time - 60;
            m = m + 1;
        }
        if(h < 10.0)
        {
            pc.putc('0');
        }
        if(h != 0)
        {
            pc.printf(h);
        }
        else
        {
            pc.putc('0');
        }
        pc.putc(':');
        if(m < 10.0)
        {
            pc.putc('0');
        }
        if(m != 0)
        {
            pc.printf(m);
        }
        else
        {
            pc.putc('0');
        }
        pc.putc(':');
        if(time < 10.0)
        {
            pc.putc('0');
        }
        if(time < 1.0)
        {
            pc.putc('0');
        }
        pc.printf(time, 100);
        int timeAsInt = time;
        if((time-timeAsInt)*100 < 10.0)
        {
            pc.putc('0');
        }
        if((time-timeAsInt)*100 < 1.0)
        {
            pc.putc('0');
        }
        pc.printf("\r\n");
    }
}