#include "mbed.h"
#include "EthernetInterface.h"

#define SERVER_PORT   80

DigitalOut garagebutton(p15);

void doorcontrol()
{
        garagebutton = 1;
        wait(0.5);
        garagebutton = 0;
}

int main (void) {
    EthernetInterface eth;
    eth.init("192.168.1.99", "255.255.255.0", "192.168.1.1"); //Use static IP
    eth.connect();
    printf("IP Address is %s\r\n", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(SERVER_PORT);
    server.listen();
    
    while (true) {
        printf("Wait for new connection...\r\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s
        
        printf("Connection from: %s\r\n", client.get_address());
        char buffer[256];
        
        // HTTP is statusline + headers + \r\n + body
        // HTTP requires statusline and all headers to have "\r\n" at the end
        // these are in that format
        char firstpage[] = {"HTTP/1.1 200 OK\r\nContent-Type: text/html; charset=UTF-8\r\nContent-Length: 213\r\n\r\n<html><head><title>Garage Door</title></head><body><h4>Garage Door Opener</h4><form action=index.html method=post><input style='border : 1px solid #000000;' value='Open/Close' type='submit' /></form></body></html>"};
        char secondpage[] = {"HTTP/1.1 200 OK\r\nContent-Type: text/html; charset=UTF-8\r\nContent-Length: 248\r\n\r\n<html><head><title>Pressing Button</title></head><body><h4>Garage Door Opener</h4><p>Door should be moving...</p><form action=index.html method=post><input style='border : 1px solid #000000;' value='Open/Close' type='submit' /></form></body></html>"};
        char error[] = {"HTTP/1.1 501 Not Implemented\r\nContent-Type: text/html; charset=UTF-8\r\nContent-Length: 100\r\n\r\n<html><head><title>Error</title></head><body>Sorry, I don't understand your request :(</body></html>"};
        char error404[] = {"HTTP/1.1 404 Not Found\r\nContent-Type: text/html; charset=UTF-8\r\nContent-Length: 147\r\n\r\n<html><head><title>Error 404</title></head><body><h1>Page not found.</h1> <h2>404</h2><br /><p>(this is not a real webserver FYI)</p></body></html>"};
        char pagemoved[] = { "HTTP/1.1 301 Moved Permanently\r\nLocation: /index.html\r\n\r\n"} ;
        //I used this website to get string length
        //http://www.string-functions.com/length.aspx
        
        while (true) { //accept data
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            
            if(buffer[0]=='G' && buffer[1]=='E' && buffer[2]=='T') //HTTP GET request
            {
                if(buffer[3]==' ' && buffer[4]=='/' && buffer[5] == ' ') // root directory
                {
                    client.send_all(firstpage, sizeof(firstpage));
                    if (n <= 0) break;
                }
                else if(buffer[3]==' ' && buffer[4]=='/' && buffer[5] == 'i' && buffer[6] == 'n' && buffer[7] == 'd' && buffer[8] == 'e'
                && buffer[9] == 'x') // index.*
                {
                    client.send_all(firstpage, sizeof(firstpage));
                    if (n <= 0) break;
                }
                else if(buffer[3]==' ' && buffer[4]=='/' && buffer[5] == 'a' 
                && buffer[6] == 'c' && buffer[7] == 't' && buffer[8] == 'i' && buffer[9] == 'o' && buffer[10] == 'n'
                && buffer[11] == '.' && buffer[12] == 'h' && buffer[13] == 't' && buffer[14] == 'm') // action.htm
                {
                    //redirect users automatically if they bookmarked action.htm
                    client.send_all(pagemoved, sizeof(firstpage));
                    if (n <= 0) break;
                }
                else
                {
                    client.send_all(error404, sizeof(error404));
                    if (n <= 0) break;
                }
            }
            else if (buffer[0]=='P' && buffer[1]=='O' && buffer[2]=='S' && buffer[3]=='T' && buffer[4]==' ' && buffer[5]=='/'
             && buffer[6]=='i' && buffer[7]=='n' && buffer[8]=='d' && buffer[9]=='e' && buffer[10]=='x' && buffer[11]=='.')
            {
                    client.send_all(secondpage, sizeof(secondpage));
                    doorcontrol();
                    if (n <= 0) break;
            }
            else
            {
                client.send_all(error, sizeof(error));
                if (n <= 0) break;
            }
        }   
        client.close();
    }
}