/*  Modified
    COPY OF https://os.mbed.com/users/wim/code/mbed_SC16IS740//file/20d8ef79d787/main.cpp
 */
#include "mbed.h"

#include "SC16IS740.h"


#if defined(TARGET_DISCO_F746NG)
// SPI for DISCO_F746NG board w/Mikro Adruino Click Shield
#define D_MOSI SPI_MOSI // D11
#define D_MISO SPI_MISO // D12
#define D_SCLK SPI_SCK // D13
#define D_CS D9   // PWM_OUT // MikroBUS 2
#define D_INTR D3 // PB_4    // MikroBUS 2
#define D_RST A2  // PF_9    // MikroBUS 2
// #define D_CS D10  // SPI_CS  // MikroBUS 1
// #define D_INTR D2 // PG_6    // MikroBUS 1
// #define D_RST A3  // PF_8    // MikroBUS 1

// I2C for DISCO_F746NG (not used)
#define D_SCL A5 // PF_6
#define D_SDA A4 // PF_7
// #define D_SCL D15 // = PB_8 Manually Wired to A5
// #define D_SDA D14 // = PB_9 Manually  Wired to A4

// Serial for DISCO_F746NG already defined.
// Optionally specify different pins for printing on UART other than the default console UART.
#define D_TX USBTX
#define D_RX USBRX

#endif

// Bizarre: If this line is above declaration SC16IS740_SPI serial_bridge,
// It does not blink ...
// But if this line is below declaration SC16IS740_SPI serial_bridge, 
// Then serial_bridge stops working after a few chars!
DigitalOut heartbeatLED(LED1);

//SPI Version
SPI spi(D_MOSI, D_MISO, D_SCLK); //MOSI, MISO, SCK
// SC16IS740_SPI serial_bridge(&spi, D_CS);
SC16IS740_SPI serial_bridge(&spi, D_CS, D_RST);  // version with Hardware Reset pin
//SC16IS752_SPI serial_bridge(&spi, D_CS, D_RST, SC16IS740::Channel_A);  // Dual UART version with Hardware Reset pin
//SC16IS752_SPI serial_bridge(&spi, D_CS, D_RST, SC16IS740::Channel_B);  // Dual UART version with Hardware Reset pin

// //I2C Version
// I2C i2c(D_SDA, D_SCL);       //SDA, SCL
// //SC16IS740_I2C serial_bridge(&i2c, SC16IS740_DEFAULT_ADDR);
// //SC16IS740_I2C serial_bridge(&i2c, SC16IS740_DEFAULT_ADDR, D_RST);
// SC16IS752_I2C serial_bridge(&i2c, SC16IS740_DEFAULT_ADDR, D_RST, SC16IS740::Channel_A);  // Dual UART version with Hardware Reset pin
// //SC16IS752_I2C serial_bridge(&i2c, SC16IS740_DEFAULT_ADDR, D_RST, SC16IS740::Channel_B);  // Dual UART version with Hardware Reset pin
 


// Create a BufferedSerial object to be used by the system I/O retarget code.
static BufferedSerial pc(D_TX, D_RX, 9600);
// static BufferedSerial pc(D_TX, D_RX, 115200);
// Specify a custom FileHandle for the console.
FileHandle * mbed::mbed_override_console(int fd) {
  return &pc;
}

void show_menu() {
  printf("0: Exit\r\n");
  printf("1: Show Menu\r\n");
  printf("2: Init\r\n");
  printf("3: IO Port Out\r\n");
  printf("4: Transparant mode\r\n");
  printf("5: Free bufferspace\r\n");
  printf("6: Enable RTS/CTS\r\n");
  printf("7: Disable RTS/CTS\r\n");
  printf("8: Write block\r\n");
  printf("9: Baudrate 9600\r\n");
  printf("A: Baudrate 115200\r\n");
  printf("B: Transparant mode with bufferdisplay\r\n");
  printf("C: Test printf \r\n");
  printf("D: Test connected\r\n");
  printf("E: Clear screen\r\n");
  printf("F: Funky ANSI\r\n");
  printf("G: Heart Beat\r\n");
  printf("\r\n");
}

// Local functions
void clear_screen() {
  //ANSI Terminal Commands
  printf("\x1B[2J");
  printf("\x1B[H");
  serial_bridge.writeString("\x1B[2J");
  serial_bridge.writeString("\x1B[H");
}

void funky_ansi() {
  int i, j, n;
  for (i = 0; i < 11; i++) {
    for (j = 0; j < 10; j++) {
      n = 10*i + j;
      if (n > 108) break;
      serial_bridge.printf("\033[%dm %3d\033[m", n, n);
    }
    serial_bridge.printf("\r\n");
  }
}

// Variables for Heartbeat and Status monitoring
Ticker heartbeat;
// Heartbeat
void heartbeat_beat() {
  heartbeatLED = ! heartbeatLED;
}
void heartbeat_start() {
  heartbeatLED = 1;
}
void heartbeat_stop() {
  heartbeat.detach();
}
int main() {
  bool running = true;
  bool running_test = true;
  char command, ch;
  char * buffer;
  int i = 0;
  heartbeat_start();
  heartbeat.attach(callback( &heartbeat_beat), 500ms);

  #if defined(TARGET_DISCO_F746NG)
  printf("\r\nHello World from DISCO_F746NG\r\n");
  #endif
  #if defined(TARGET_LPC1768)
  printf("\r\nHello World from LPC1768\r\n");
  #endif
  #if defined(TARGET_KL25Z)
  printf("\r\nHello World from KL25Z\r\n");
  #endif
  #if defined(TARGET_LPC812)
  printf("\r\nHello World from LPC812\r\n");
  #endif

  // We need to enable flow control or we overflow buffers and
  // lose data when used with the WiFly. Note that flow control
  // needs to be enabled on the WiFly for this to work but it's
  // possible to do that with flow control enabled here but not there.
  //  serial_bridge.set_flow_control(SC16IS740::RTSCTS);

  // Not available of SC16IS740:
  // serial_bridge.ioSetDirection(0xFF); // All outputs
  // serial_bridge.ioSetState(0xFF);     // All On

  show_menu();

  while (running) {
    // heartbeat_beat();

    if (pc.readable()) {
      // pc.read( & command, 1);
      command = getchar();

      printf("command= %c \r\n", command);

      switch (command) {
      case '0':
        printf("Done\r\n");
        running = false;
        break;

      case '1':
        show_menu();
        break;

      case '2':
        printf("Hardware Reset\r\n");
        serial_bridge.hwReset(); //test

        printf("Init\r\n");
        serial_bridge._init();
        printf("Hardware Init done\r\n");
        break;

      case '3':
        printf("IO Port Out\r\n");

        i = 0;
        while (!pc.readable()) {
          serial_bridge.ioSetState(~i);
          //                       serial_bridge.ioGetState() ;                       //test
          thread_sleep_for(500);
          printf("*");
          i = (i + 1) & 0xFF;
        }

        pc.read( & ch, 1);
        printf("IO Port Out Done\r\n");
        break;

      case '4':
        printf("Transparant Mode, Enter '#' to quit...\r\n");

        running_test = true;

        while (running_test) {
          // From SPI/I2C to serial
          while (running_test && pc.readable()) {
            // pc.read( & ch, 1);
            ch = getchar();
            running_test = (ch != '#');
            serial_bridge.putc(ch);
          }

          // From Serial to SPI/I2C
          while (running_test && serial_bridge.readable()) {
            ch = serial_bridge.getc();
            running_test = (ch != '#');
            printf("%s", & ch);
          }

        }

        printf("\r\nTransparant Mode done\r\n");
        break;

      case '5':
        printf("Available for Reading = %3d (Free Space = %3d)\r\n", serial_bridge.readableCount(), SC16IS740_FIFO_RX - serial_bridge.readableCount());
        printf("Available for Writing = %3d (Used Space = %3d)\r\n", serial_bridge.writableCount(), SC16IS740_FIFO_TX - serial_bridge.writableCount());
        break;

      case '6':
        printf("Enable RTS/CTS\r\n");
        serial_bridge.set_flow_control(SC16IS740::RTSCTS);
        break;
      case '7':
        printf("Disable RTS/CTS\r\n");
        serial_bridge.set_flow_control(SC16IS740::Disabled);
        break;

      case '8':
        printf("Write block\r\n");
        serial_bridge.writeString("Hello World from mbed and SC16IS740\r\n");
        break;

      case '9':
        printf("Baudrate = 9600, Divisor = %d\r\n", (int) SC16IS740_BAUDRATE_DIVISOR(9600));
        serial_bridge.baud(9600);
        break;

      case 'a':
      case 'A':
        printf("Baudrate = 115200, Divisor = %d\r\n", (int) SC16IS740_BAUDRATE_DIVISOR(115200));
        serial_bridge.baud(115200);
        break;

      case 'b':
      case 'B':
        printf("Transparant Mode with buffer display, Enter '#' to quit...\r\n");

        running_test = true;

        while (running_test) {
          // From SPI/I2C to serial
          while (running_test && pc.readable()) {
            // pc.read( & ch, 1);
            ch = getchar();
            running_test = (ch != '#');
            serial_bridge.putc(ch);

            // // Show buffers when character was entered
            // printf("\r\n");
            // printf("Available for Reading = %3d (Free Space = %3d)\r\n", serial_bridge.readableCount(), SC16IS740_FIFO_RX - serial_bridge.readableCount());
            // printf("Available for Writing = %3d (Used Space = %3d)\r\n", serial_bridge.writableCount(), SC16IS740_FIFO_TX - serial_bridge.writableCount());
          }

          // From Serial to SPI/I2C
          while (running_test && serial_bridge.readable()) {
            ch = serial_bridge.getc();
            running_test = (ch != '#');
            putchar(ch);
            // printf("%s", & ch);
          }

        }

        printf("\r\nTransparant Mode done\r\n");
        break;

      case 'c':
      case 'C':
        printf("Test printf() \r\n");

        serial_bridge.printf("Available for Reading = %3d (Free Space = %3d)\r\n", serial_bridge.readableCount(), SC16IS740_FIFO_RX - serial_bridge.readableCount());
        serial_bridge.printf("Available for Writing = %3d (Used Space = %3d)\r\n", serial_bridge.writableCount(), SC16IS740_FIFO_TX - serial_bridge.writableCount());

        printf("\r\nTest printf() done\r\n");
        break;
      case 'd':
      case 'D':
        printf("Test connected\r\n");
        if (!serial_bridge.connected()) {
          printf("Failed to detect UART bridge\r\n");
        } else {
          printf("Found UART bridge!\r\n");
        }
        break;
      case 'e':
      case 'E':
        printf("Clear Screen\r\n");
        clear_screen();
        break;
      case 'f':
      case 'F':
        printf("Funky ANSI\r\n");
        funky_ansi();
        break;
      case 'g':
      case 'G':
        printf("Heart Beat\r\n");
        // heartbeat_beat();
        heartbeatLED = ! heartbeatLED;
        break;
      default:
        break;

      } //switch
    } //if
  } //while

  printf("\nBye World!\n");
}