/*
    Copyright (c) 2011 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

#ifdef MAX3100_EXAMPLE_COMPILE

/*
 * Connecting up the MAX3100 for this test program. Note, to form a "loopback"
 * the MAX3100 TX pin (13) is connected to the RX pin (12). Don't forget thwe Xtal
 * and power pins that are not shown here. Although I do PullUp mode on the IRQ pin
 * I still needed a real external pull up resistor on the IRQ lines. You may need to
 * add two pullups to teh two interrupt lines at p9 and p11.
 *                                          ____________
 *                                         /            \ U1
 * Mbed MOSI p5 |-------*---------------> 1| Din     TX | 13 ------\
 *      MISO p6 |-----*-|---------------> 2| Dout       |          |
 *      SCLK p7 |---*-|-|---------------> 3| Sclk    RX | 12 ------/
 *           p8 |---|-|-|---------------> 4| CS         |
 *           p9 |---|-|-|---------------> 5| IRQ        | MAX3100 
 *                  | | |        +5v ---> 6| SHTD       | Xtal and PWR not shown.
 *                  | | |                  \____________/
 *                  | | |                   ____________
 *                  | | |                  /            \ U2
 *                  | | \---------------> 1| Din     TX | 13 ------\
 *                  | \-----------------> 2| Dout       |          |
 *                  \-------------------> 3| Sclk    RX | 12 ------/
 *          p10 |-----------------------> 4| CS         |
 *          p11 |-----------------------> 5| IRQ        | MAX3100
 *                               +5v ---> 6| SHTD       | Xtal and PWR not shown.
 *                                         \____________/
 *
 * This example shows two MAX3100 sharing a single SPI bus. Each device, however, 
 * still has it's own CS and IRQ signals.
 */

#include "mbed.h"
#include "MAX3100.h"

Serial  pc(USBTX, USBRX);
SPI     spi(p5, p6, p7);
MAX3100 *max1;
MAX3100 *max2;

int main() {
        
    // Set the PC USB serial baud rate.
    pc.baud(115200);

    // Format the SPI interface.    
    spi.format(16, 0);
    spi.frequency(MAX3100_SPI_FREQ);
    
    // Create the two MAX3100 objects which share the SPI bus.
    max1 = new MAX3100(&spi, p8, p9);
    max2 = new MAX3100(&spi, p10, p11);
    
    // Enable the interrupts.
    max1->enableRxIrq();
    max1->enableTxIrq();
    max2->enableRxIrq();
    max2->enableTxIrq();
    
    max1->printf("\nHello World.\n");
    //max2->printf("\nHello World.\n");
    
    // Any byte received on the "USB serial port" is sent to both MAX3100 devices.
    // Any byte received by a MAX3100 device is sent to the "USB serial port".
    while (1) {
        if (pc.readable()) {
            int c = pc.getc();
            max1->putc(c);
            max2->putc(c);            
        }
        if (max1->readable()) {
            pc.putc( max1->getc() );
        }
        if (max2->readable()) {
            pc.putc( max2->getc() );
        }
    }    
}

#endif
