#include "mbed.h"
#include "MAX11300.h"
#include "MAX11300Hex.h" // Contains PIXI configuration: port0 ADC, port1 DAC

#define D_TX USBTX
#define D_RX USBRX
// Create a BufferedSerial object to be used by the system I/O retarget code.
static BufferedSerial pc(D_TX, D_RX, 115200);
// static BufferedSerial pc(D_TX, D_RX, 115200);
// Specify a custom FileHandle for the console.
FileHandle * mbed::mbed_override_console(int fd) {
  return &pc;
}
DigitalOut myled(LED1);

// SPI for DISCO_F746NG board w/Mikro Adruino Click Shield
SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK);
// SPI for DISCO_F746NG board w/Mikro Adruino Click Shield
// #define D_CS D9   // PWM_OUT // MikroBUS 2
// #define D_INTR D3 // PB_4    // MikroBUS 2
// #define D_RST A2  // PF_9    // MikroBUS 2
#define D_CS D10  // SPI_CS  // MikroBUS 1
#define D_INTR D2 // PG_6    // MikroBUS 1
#define D_RST A3  // PF_8    // MikroBUS 1

// main() runs in its own thread in the OS
int main()
{
    printf("MAX11300 Test...\r\n");
    uint16_t adcvalue = 0; // 12-bit
    float f_adcvalue = 0;
    uint16_t dacvalue = 0xFFF; // 12-bit
    float f_dacvalue = 0;

    uint8_t step = 0;
    
    for(int i=0;i<100;i++) {
        myled = !myled;thread_sleep_for(10);
    }
    MAX11300 mikroe_pixi_click(spi, D_CS, D_INTR, NC);
    MAX11300::CmdResult pixi_result;
    myled = !myled;thread_sleep_for(1000);myled = !myled;

    while (1) {
        f_dacvalue = 10.0*(step/10.0)-5.0; // Walk -5..5V in 10 steps.
        dacvalue = static_cast<uint16_t>( 4095 * ((f_dacvalue+5)/10.0) );// 12-bit over range 0.0-2.5 volts

        pixi_result = mikroe_pixi_click.single_ended_dac_write(MAX11300::PORT1, dacvalue);
        if(pixi_result != MAX11300::Success)
            printf("Failure in single_ended_dac_write\r\n");
        
        thread_sleep_for(1*1); 

        mikroe_pixi_click.single_ended_adc_read(MAX11300::PORT0, (uint16_t &) adcvalue);
        if(pixi_result != MAX11300::Success)
            printf("Failure in single_ended_adc_read\r\n");
        
        f_adcvalue = (adcvalue * 10.0) / 4095 - 5.0; // ADC voltage range -5...5V
        f_dacvalue = (dacvalue * 10.0) / 4095 - 5.0;

        printf("%d: dac:%04X (%+f), adc:%04X (%+f), err:(%+f)\r\n", step, dacvalue, f_dacvalue, adcvalue, f_adcvalue, f_adcvalue-f_dacvalue);
        
        myled = !myled; // Does not work because SPI classes are loaded??
        thread_sleep_for(1*1); 
        
        step++;
        if (step >= 10) step = 0;
    }
}

