
#include "mbed.h" // needed for anything mbed
// #include "lvgl_stm32f7.h" // needed for lv_coord_t
#include "lvgl.h"

static lv_obj_t * tv;
static lv_obj_t * t1;

static void controls_create(lv_obj_t * parent);

void lv_demo_widgets(void)
{
    tv = lv_tabview_create(lv_scr_act(), NULL);
    t1 = lv_tabview_add_tab(tv, "Hello World");
    controls_create(t1);

}
#define OPTLIGHT "Light"
#define OPTDARK "Dark"
static void mbox_handler(lv_obj_t * obj, lv_event_t event)
{
#if LV_USE_THEME_MATERIAL
    if(event == LV_EVENT_VALUE_CHANGED) {
        uint32_t flag ;
        const char *btn_text = lv_msgbox_get_active_btn_text(obj);
        if( 0 == strcmp(btn_text, OPTLIGHT) )
            flag = LV_THEME_MATERIAL_FLAG_LIGHT;
        if( 0 == strcmp(btn_text, OPTDARK) )
            flag = LV_THEME_MATERIAL_FLAG_DARK;
        if(LV_THEME_DEFAULT_INIT != lv_theme_material_init)
            return;
        LV_THEME_DEFAULT_INIT(lv_theme_get_color_primary(), lv_theme_get_color_secondary(),
            flag,
            lv_theme_get_font_small(), lv_theme_get_font_normal(), lv_theme_get_font_subtitle(), lv_theme_get_font_title());
        lv_msgbox_start_auto_close(obj, 10);
    }
#endif
}
static void controls_create(lv_obj_t * parent)
{
    lv_page_set_scrl_layout(parent, LV_LAYOUT_PRETTY_TOP);
    static const char * btns[] = {OPTLIGHT, OPTDARK, ""};

    lv_obj_t * mbox = lv_msgbox_create(lv_scr_act(), NULL);
    lv_msgbox_set_text(mbox, "How are you today?");
    lv_msgbox_add_btns(mbox, btns);
    lv_obj_t * btnm = lv_msgbox_get_btnmatrix(mbox);
    lv_btnmatrix_set_btn_ctrl(btnm, 1, LV_BTNMATRIX_CTRL_CHECK_STATE);
    lv_obj_set_event_cb(mbox, mbox_handler);
}


/*
    lv_helloworld()     Example minimal LV GUI
 */
void lv_helloworld(void)
{
    lv_demo_widgets();
}