
#include "lvgl_f746ng.h"

static void lv_ticker_func() {
  // Call lv_tick_inc(x) every x milliseconds in a Timer or Task (x should be
  // between 1 and 10). It is required for the internal timing of LittlevGL.
  lv_tick_inc(LVGL_TICK_INC);
  // Call lv_task_handler() periodically every few milliseconds.
  // It will redraw the screen if required, handle input devices etc.
  lv_task_handler();
}

#ifdef LVGL_USE_THREAD
static Thread lvgl_thread; // mbed Thread for lvgl
static void lv_thread_func() {
  printf("lv_thread_func from context %p\n", ThisThread::get_id());
  while (1) {
    ThisThread::sleep_for(LVGL_TICK_INC * 1ms);
    lv_ticker_func();
  }
}
#else
static Ticker lvgl_ticker; // mbed Ticker for lvgl
#endif /* LVGL_USE_THREAD */

/* Initialize lvgl + target port specifics + mbed ticker or thread. */
void lvgl_f746ng_init() {
  printf("lvgl_f746ng_init from context %p\n", ThisThread::get_id());
  lv_init();            // Initialize the LittlevGL
  lv_port_disp_init();  // Initialize diplay
  lv_port_indev_init(); // Initialize touchpad
#ifdef LVGL_USE_THREAD
  // Approach using mbed Thread
  lvgl_thread.start(lv_thread_func);
  // lvgl_thread.join();  // it will never join
#else
  // Approach using mbed Ticker
  lvgl_ticker.attach(callback(&lv_ticker_func), LVGL_TICK_INC * 1ms);
#endif /* LVGL_USE_THREAD */
}

