#include "mbed.h"
#include "LTC2601.h" 

// SPI for DISCO_F746NG board w/Mikro Arduino Click Shield
SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK);
#define D_CS D9   // PWM_OUT // MikroBUS 2
#define D_INTR D3 // PB_4    // MikroBUS 2
#define D_RST A2  // PF_9    // MikroBUS 2
// #define D_CS D10  // SPI_CS  // MikroBUS 1
// #define D_INTR D2 // PG_6    // MikroBUS 1
// #define D_RST A3  // PF_8    // MikroBUS 1

// Instance
LTC2601 mikroe_dac2_click(&spi, D_CS, D_RST);
  
int main() {

    printf("LTC2601 Testing\n");

    while (1) {

        mikroe_dac2_click.hwReset();
        printf("Hardware Reset\n");

        for (int v=0; v<6; v++) {
            mikroe_dac2_click.updateVoltage((float)v);
            printf("Set Voltage: %fV\n", (float)v);
            ThisThread::sleep_for(2000ms);
        }
            
        for (int i=0; i<4; i++) {
            printf("Ramping 0...0xFFFF 10us step...\n");
            for (uint16_t v=0; v<0xFFFF; v++) {
                mikroe_dac2_click.updateVoltage(v);
                wait_us(10); // Settling time typ. 7us
            }
        }
        printf("Ramping Done.\n");
        
        mikroe_dac2_click.powerDown();
        printf("Power Down.\n");

        ThisThread::sleep_for(2000ms);

    }
}
