
#ifndef _LTC2601_H
#define _LTC2601_H
#include "mbed.h"
 
class LTC2601 {
public:
    /** Commands (Table 1): 
    * C3 C2 C1 C0
    *  0  0  0  0 Write to Input Register
    *  0  0  0  1 Update (Power Up) DAC Register
    *  0  0  1  1 Write to and Update (Power Up)
    *  0  1  0  0 Power Down (and ignores data word)
    *  1  1  1  1 No Operation (ignores data word)
    * The first three commands all seem to have the same effect (update and power up). Commands not shown seem ignored.
    * 
    */
    enum CommandName { 
        WRITE           = (0b0000<<4),
        UPDATE          = (0b0001<<4),
        WRITE_UPDATE    = (0b0011<<4),
        POWERDOWN       = (0b0100<<4),
        NOOPERATION     = (0b1111<<4),
    } ;
    /* Constructor */
    LTC2601 (SPI *spi, PinName cs, PinName rst);

    /* Set DAC voltage 0...5.0V */
    void updateVoltage(float voltage);
    /* Set DAC voltage 0...0xFFFF */
    void updateVoltage(uint16_t dac_value);
    void powerDown();
    /*
    * DAC 2 Click only has no MOSI function
    *
    * Input First SPI write 16-bit:
    * 8 bits of don't care
    * 4 bits of command word (C3-C0)
    * 4 bits if don't care
    *
    * Input Second SPI write 16-bit: 
    * 16 bits of data word (D15-D0)
    * This data word encodes the desired DAC value between 0.0V and Vref.
    * Vref on the Mikroe DAC2 Click equals 5.0V (jumper default).
    *
    */
    void writeRegister(CommandName command, uint16_t data);
    void hwReset();
protected:
private:
    SPI *_spi;
    DigitalOut _cs;
    DigitalOut _rst;
};


#endif  //  _LTC2601_H