#include "LTC2601.h"
#include "mbed.h"

/* Constructor */
LTC2601::LTC2601 (SPI *spi, PinName cs, PinName rst) : _spi(spi), _cs(cs), _rst(rst) {
    _cs = 1;  // deselect
    _rst = 1; // deselect
    _spi->format(16, 0);          // 16-bit word length
    _spi->frequency(50*1000*1000); // 50 MHz spi clock

};
/* Set DAC voltage 0...5.0V */
void LTC2601::updateVoltage(float voltage) {
    uint16_t dac_value = (voltage/5.0) * 0xFFFF;
    updateVoltage(dac_value);
}
/* Set DAC voltage 0...0xFFFF */
void LTC2601::updateVoltage(uint16_t dac_value) {
    writeRegister(WRITE, dac_value);
}
void LTC2601::powerDown() {
    writeRegister(POWERDOWN, NULL);
}
/*
* DAC 2 Click only has no MOSI function
*
* Input First SPI write 16-bit:
* 8 bits of don't care
* 4 bits of command word (C3-C0)
* 4 bits if don't care
*
* Input Second SPI write 16-bit: 
* 16 bits of data word (D15-D0)
* This data word encodes the desired DAC value between 0.0V and Vref.
* Vref on the Mikroe DAC2 Click equals 5.0V (jumper default).
*
*/
void LTC2601::writeRegister(CommandName command, uint16_t data) {
    _cs = 0; //  select;
    _spi->write(command);
    _spi->write(data);
    _cs = 1; //  deselect;
}
void LTC2601::hwReset() {
    _rst = 1; // select
    wait_us(10*1000);   // wait some milliseconds (test only)
    _rst = 1; // deselect
}
