/* mbed Example Program
 * Copyright (c) 2006-2014 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"

DigitalOut myled(LED1);

// For approach Three
Ticker blinkticker;
void blink()
{
    myled = !myled;
    printf("myled = %d (blinkticker)\r\n", (uint8_t) myled );
}

// For approach Four: // A class for blink()-ing a DigitalOut
class Blinker {
public:
    Blinker(PinName pin) : _pin(pin)
    {
        _pin = 0;
    }
    void blink()
    {
        _pin = !_pin;
        printf("_pin = %d (Blinker::blink)\r\n", (uint8_t) _pin );
    }
private:
    DigitalOut _pin;
};
Blinker myblinker(LED2);

// For approach Five
PwmOut mypwm(PWM_OUT);
InterruptIn myint(D10); // Manually Wire D10 to PWM_OUT (D9)
void blinkinterrupt()
{
    myled = !myled;
    printf("myled = %d (blinkinterrupt)\r\n", (uint8_t) myled );
}

int main()
{
    // check that myled object is initialized and connected to a pin
    if(myled.is_connected()) {
        printf("myled is initialized and connected!\r\n");
    }

    // Blink LED
    for(int i=0; i<3; i++) {
        
        // one way
        myled = 1;          // set LED1 pin to high
        printf("myled = %d (assign)\r\n", (uint8_t) myled );
        ThisThread::sleep_for(500ms);

        // another method
        myled.write(0);     // set LED1 pin to low
        printf("myled = %d (write())\r\n",myled.read() );
        ThisThread::sleep_for(500ms);
    }

    // A third blinker
    blinkticker.attach(&blink, 500ms); // call function every 500ms
    ThisThread::sleep_for(2500ms); // Let the main thread rest ...
    blinkticker.detach();

    // A fourth blinker
    // the address of the object, member function, and interval
    blinkticker.attach(callback(&myblinker, &Blinker::blink), 500ms);
    ThisThread::sleep_for(2500ms); // Let the main thread rest ...
    blinkticker.detach();

    // A fifth blinker
    blinkinterrupt(); 		// Test function works
    myint.rise(callback(&blinkinterrupt)); // Start listening on rise events
    mypwm.period_ms(500);  // PWM period is 500ms
    mypwm.write(0.5);      // Duty Cycle: 50% HIGH time.

    printf("Good Bye.\r\n");
    while (true) {
        ThisThread::sleep_for(1h); // Zzz
    }

}
