//Notebook page https://os.mbed.com/users/JohnnyK/notebook/how-start-with-the-littlevgl/
#include "mbed.h"
#include "lvgl/lvgl.h"
#include "lv_port_disp.h"
#include "lv_port_indev.h"
#include "lv_examples/lv_examples.h"

Ticker ticker;                                  //Ticker for lvgl                    

//Callback function for lvgl timing.
void lv_ticker_func(){
    lv_tick_inc(10); 
    //Call lv_tick_inc(x) every x milliseconds in a Timer or Task (x should be between 1 and 10). 
    //It is required for the internal timing of LittlevGL.
    lv_task_handler(); 
    //Call lv_task_handler() periodically every few milliseconds. 
    //It will redraw the screen if required, handle input devices etc.
}

int main()
{
    printf("LittlevGL GUI-"); 
    lv_init();                                  //Initialize the LittlevGL
    lv_port_disp_init();                        //Initialize diplay 
    lv_port_indev_init();                       //Initialize touchpad
    ticker.attach(callback(&lv_ticker_func), 10ms); //Attach callback to ticker

    lv_demo_widgets();

    while(1) {
        //do something   
        thread_sleep_for(100);
    }
}
