#ifndef MBED_LCD_2WIRE_H
#define MBED_LCD_2WIRE_H

#include "mbed.h"

class lcd_2wire {
public:
    lcd_2wire(PinName pinc, PinName pind);

#define LCD_CMD_MODE 0
#define LCD_DATA_MODE 1
#define LCD_INIT_MODE 2
#define LCD_CLR 1
#define LCD_HOME 2
#define LCD_DISP_ON 0x0C
#define LCD_FUNCTION_4BIT_1LINE 0x20
#define LCD_FUNCTION_4BIT_2LINE 0x28
#define LCD_FUNCTION_8BIT_1LINE 0x30
#define LCD_FUNCTION_8BIT_2LINE 0x38
#define LCD_COLS 20
#define LCD_ROWS 4
#define LCD_POWER_UP_DELAY_MS 50
#define LCD_INIT_DELAY_MS 5


    void lcd_init(void);
    void lcd_clear();
    void lcd_home(void);
    void lcd_goto_xy(int xpos, int ypos);
    void lcd_write_char(int chr);
    void lcd_write_char_xy(int x, int y, int chr);
    void lcd_write_str(const char *sp);
    void lcd_write_str_xy(int x,int y,const char *sp);

private:
    DigitalOut _pinc;
    DigitalOut _pind;
    void LCD_SET_CLK();
    void LCD_CLR_CLK();
    void LCD_SET_DATA();
    void LCD_CLR_DATA();
    void lcd_delay();
    void lcd_init_shift_reg(int mode);
    void lcd_shift_nibble(int data);
    void lcd_shift_byte(int data, int mode);
    void lcd_write_command(int command);
    void lcd_write_data(int data);
    void lcd_function_mode(int function_mode);
    void lcd_display_mode(int display_mode);
    void lcd_entry_mode(int entry_mode);
};
#endif