#include "mbed.h"
#include "lcd_2wire.h"


lcd_2wire::lcd_2wire (PinName pinc, PinName pind ): _pinc(pinc),  _pind(pind) {
    _pinc = 0;//clock signal
    _pind = 0;// data signal
}
//-----------------------------
void lcd_2wire::LCD_SET_CLK(void) {
    _pinc = 1;
}
//---------------------------------
void lcd_2wire::LCD_CLR_CLK(void) {
    _pinc = 0;
}
//----------------------------------
void lcd_2wire::LCD_SET_DATA(void) {
    _pind = 1;
}
//----------------------------------
void lcd_2wire::LCD_CLR_DATA(void) {
    _pind = 0;
}
//----------------------------------
int LCD_ROW_TABLE[4] = {  //Display row addresses
    0x80,
    0xC0,
    0x80 + LCD_COLS,
    0xC0 + LCD_COLS
};
//----------------------------------------
void lcd_2wire::lcd_delay(void) { 
    wait_us(100);
}
//-------------------------------------------
void lcd_2wire::lcd_init_shift_reg(int mode) {   //Clear shift register, set E and RS
    int n;

    LCD_CLR_DATA(); //clear data signal
    lcd_delay();

//clear all outputs of shift register
    for (n=7; n; n--) {
        LCD_SET_CLK();
        lcd_delay();
        LCD_CLR_CLK();
    }

//Set high level for E at Q7
    LCD_SET_DATA();
    lcd_delay();
    LCD_SET_CLK();
    lcd_delay();
    LCD_CLR_CLK();

//Set level for RS at Q6
    if (mode == LCD_DATA_MODE) {
        LCD_SET_DATA();
    } else {
        LCD_CLR_DATA();
    }
    lcd_delay();
    LCD_SET_CLK();
    lcd_delay();
    LCD_CLR_CLK();
}
//----------------------------------------------
void lcd_2wire::lcd_shift_nibble(int data) { //Clock in 4 bits of data
    int n, mask= 0x08;
    for (n =4; n; n--) {   //do this for 4 databits
        if (data & mask) {  // set or reset data signal
            LCD_SET_DATA();
        } else {
            LCD_CLR_DATA();
        }
        LCD_SET_CLK();
        lcd_delay();
        LCD_CLR_CLK();
        mask >>= 1;  // shift right
    }
    LCD_SET_CLK();
    lcd_delay();
    LCD_CLR_CLK();
}
//-------------------------------------------------

void lcd_2wire::lcd_shift_byte(int data , int mode) {
    lcd_init_shift_reg(mode);
    lcd_shift_nibble(data >> 4);
    LCD_SET_DATA();
    lcd_delay();
    if (mode != LCD_INIT_MODE) {
        lcd_init_shift_reg(mode);
        lcd_shift_nibble(data);
        LCD_SET_DATA();
        lcd_delay();
    }
    LCD_CLR_DATA();
    lcd_delay();
}
//-------------------------------------------------
void lcd_2wire::lcd_write_command(int command) {
    lcd_shift_byte(command,LCD_CMD_MODE);
}
//---------------------------------------------------
void lcd_2wire::lcd_write_data(int data) {
    lcd_shift_byte(data,LCD_DATA_MODE);
}
//----------------------------------------------
//Functions flags - Bit 0  0: 5x7 Dots   1:5x10 Dots
//                  Bit 1  0: 1 Row      1: 2 Rows
//                  Bit 2  0: 4-Bit Intf 1: 8-Bit Intf
void lcd_2wire::lcd_function_mode(int function_mode) {
    function_mode =((function_mode & 7) << 2) + 0x20;
    lcd_write_command(function_mode);
}
//-------------------------------------------------
void lcd_2wire::lcd_display_mode(int display_mode) {
    display_mode =(display_mode & 7) + 0x08;
    lcd_write_command(display_mode);
}
//-------------------------------------------------
void lcd_2wire::lcd_entry_mode(int entry_mode) {
    entry_mode =(entry_mode & 3) + 0x04;
    lcd_write_command(entry_mode);
}
//-------------------------------------------------
void lcd_2wire::lcd_clear(void) {
    lcd_write_command(LCD_CLR);
}
//--------------------------------------------------
void lcd_2wire::lcd_home(void) {
    lcd_write_command(LCD_HOME);
}
//--------------------------------------------------
void lcd_2wire::lcd_goto_xy(int xpos, int ypos) {
    if (xpos < LCD_COLS && ypos <LCD_ROWS) {
        lcd_write_command(LCD_ROW_TABLE[ypos] + xpos);
    }
}
//---------------------------------------------------
void lcd_2wire::lcd_write_char(int chr) {
    lcd_write_data(chr);
}
//--------------------------------------------------
void lcd_2wire::lcd_write_char_xy(int x, int y, int chr) {
    lcd_goto_xy(x,y);
    lcd_write_data(chr);
}
//------------------------------------------------
void lcd_2wire::lcd_write_str(const char *sp) {
    while (*sp) {
        lcd_write_data(*sp++);
    }
}
//----------------------------------------------------
void lcd_2wire::lcd_write_str_xy(int x, int y, const char *sp) {
    lcd_goto_xy(x,y);
    lcd_write_data(*sp++);
}
//----------------------------------------------------
void lcd_2wire::lcd_init(void) {
    LCD_CLR_CLK();
    LCD_CLR_DATA();

    wait_ms(LCD_POWER_UP_DELAY_MS);

//Startinitialisation

    lcd_shift_byte(LCD_FUNCTION_8BIT_1LINE,LCD_INIT_MODE);
    wait_ms(LCD_INIT_DELAY_MS);
    lcd_shift_byte(LCD_FUNCTION_8BIT_1LINE,LCD_INIT_MODE);
    wait_ms(LCD_INIT_DELAY_MS);
    lcd_shift_byte(LCD_FUNCTION_8BIT_1LINE,LCD_INIT_MODE);
    wait_ms(LCD_INIT_DELAY_MS);
    lcd_shift_byte(LCD_FUNCTION_4BIT_1LINE,LCD_INIT_MODE);
    wait_ms(LCD_INIT_DELAY_MS);
//Display is in 4 bit I/O mode now
#if (LCD_ROWS > 1)
    lcd_write_command(LCD_FUNCTION_4BIT_2LINE);
#else
    lcd_write_command(LCD_FUNCTION_4BIT_1LINE);
#endif
    wait_ms(LCD_INIT_DELAY_MS);
    lcd_write_command(LCD_DISP_ON);
    wait_ms(LCD_INIT_DELAY_MS);
    lcd_write_command(LCD_CLR);
    lcd_write_command(LCD_HOME);
    wait_ms(LCD_INIT_DELAY_MS);
}

