#include "mbed.h"
#include "rtos.h"
#include "wave_player.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
 
DigitalOut led1(LED1);
DigitalOut led2(LED2);

AnalogOut DACout(p18);
wave_player waver(&DACout);
uLCD_4DGL uLCD(p28, p27, p29); // serial tx, serial rx, reset pin;
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
PwmOut red(p25);
PwmOut green(p24);
PwmOut blue(p23);



Mutex lcd_mutex;

FILE *wave_file;

int height = 15;
int height2 = 15;

FILE *fp;
void wav_thread() {
    
    while (true) {
        bool play = true;
        int vol = 1;
        fp = fopen("/sd/wavfiles/tt.wav", "r");
        waver.play(fp, &play, &vol);
        Thread::wait(1000);


    }
}
void lcd_thread1()
    {
        while (true)
        {
            for (int x = 0; x < 13; x++)
            {
                lcd_mutex.lock();
                uLCD.filled_circle(25,height,15,BLACK);
                height += 7;
                uLCD.filled_circle(25,height,15,WHITE);
                lcd_mutex.unlock();
                Thread::wait(100);
            }
            for (int x = 0; x < 13; x++)
            {
                lcd_mutex.lock();
                uLCD.filled_circle(25,height,15,BLACK);
                height -= 7;
                uLCD.filled_circle(25,height,15,WHITE);
                lcd_mutex.unlock();
                Thread::wait(100);
            }
        }   
    }
 void lcd_thread2() 
    {
     while (true)
        {
            for (int x = 0; x < 13; x++)
            {
                lcd_mutex.lock();
                uLCD.filled_circle(60,height2,15,BLACK);
                height2 += 7;
                uLCD.filled_circle(60,height2,15,WHITE);
                lcd_mutex.unlock();
                Thread::wait(100);
            }
            for (int x = 0; x < 13; x++)
            {
                lcd_mutex.lock();
                uLCD.filled_circle(60,height2,15,BLACK);
                height2 -= 7;
                uLCD.filled_circle(60,height2,15,WHITE);
                lcd_mutex.unlock();
                Thread::wait(100);
            }
        }   
    }
 
int main() {
    
    

    
    //uLCD.cls();
    
    Thread thread1;
    Thread thread2;
    Thread thread3;
    thread1.start(lcd_thread2);
    thread2.start(lcd_thread1);
    thread3.start(wav_thread);
    
    while (true) {
        for (float x=0.45; x >= 0; x -= 0.025) {
            red = x;
            green = x;
            blue = x;
            Thread::wait(100);
        }
        for (float x = 0; x <= 0.45; x += 0.025) {
            red = x;
            green = x;
            blue = x;
            Thread::wait(100);
        }
    }
}
