// CooCox RTOS v1.1.4 with simple example
// Two LEDs will blink with 250ms and 500ms interval based on two seperate tasks
// by electronix79, 29/July/2011
//
// Comments: Nice work by Eric Ebert which used CooCox RTOS v1.1.3 but all files of CoOS were in one main folder,
// so I create new project with the same structure as in CooCox design and of cause I use the updated version 1.1.4 

#include "mbed.h"

#include <CoOS.h>

DigitalOut led1(LED1), led4(LED4);

#define TASK_STACK_SIZE         128         /*!< Define task size */

#define PRIORITY_TASK1          1           /* Priority of task 1 */
#define PRIORITY_TASK2          2           /* Priority of task 2 */
#define PRIORITY_TASK3          3           /* Priority of task 3 */

OS_STK    task1_stk[TASK_STACK_SIZE];       /*!< Define "task1" task stack */
OS_STK    task2_stk[TASK_STACK_SIZE];       /*!< Define "task2" task stack */
OS_STK    task3_stk[TASK_STACK_SIZE];       /*!< Define "task3" task stack */

OS_TID    task1_id;                         /*!< Task ID of 'task1'. */
OS_TID    task2_id;                         /*!< Task ID of 'task2'. */
OS_TID    task3_id;                         /*!< Task ID of 'task3'. */

OS_MutexID	mut_1;							/*!< Save id of mutex.	*/

void task1(void *);
void task2(void *);
void task3(void *);

void task1(void* pdata)
{   
    mut_1 = CoCreateMutex();				/* Create a mutex */

    task2_id = CoCreateTask(task2, (void *)0, PRIORITY_TASK2, &task2_stk[TASK_STACK_SIZE-1], TASK_STACK_SIZE);
    task3_id = CoCreateTask(task3, (void *)0, PRIORITY_TASK3, &task3_stk[TASK_STACK_SIZE-1], TASK_STACK_SIZE);
    
    CoExitTask();							/* Delete 'task1' task. */
}

void task2(void* pdata)
{
    for(;;)
    {
        CoEnterMutexSection(mut_1);			/* Enter critical region */
        led1 = 1;                           /* Turn On Led */
        CoLeaveMutexSection(mut_1);			/* Exit critical region */
        CoTickDelay(250);                   /* Delay 250ms */
        CoEnterMutexSection(mut_1);			/* Enter critical region */
        led1 = 0;                           /* Turn Off Led */
        CoLeaveMutexSection(mut_1);			/* Exit critical region */
        CoTickDelay(250);                   /* Delay 250ms */
    }
}

void task3(void* pdata)
{
    for(;;)
    {
        CoEnterMutexSection(mut_1);			/* Enter critical region */
        led4 = 1;                           /* Turn On Led */
        CoLeaveMutexSection(mut_1);			/* Exit critical region */
        CoTickDelay(500);                   /* Delay 500ms */
        CoEnterMutexSection(mut_1);			/* Enter critical region */
        led4 = 0;                           /* Turn Off Led */
        CoLeaveMutexSection(mut_1);			/* Exit critical region */
        CoTickDelay(500);                   /* Delay 500ms */
    }
}

int main()
{
    CoInitOS();                             /*!< Initial CooCox CoOS */

    task1_id = CoCreateTask(task1, (void *)0, PRIORITY_TASK1, &task1_stk[TASK_STACK_SIZE-1], TASK_STACK_SIZE);

    CoStartOS();                            /*!< Start multitask */

    while (1);                              /*!< The code don't reach here */
}
