//still getting 300uA consumption when sensor is on or OFF/disabled.  Weird.
//purple board w/ beacon sensor code gets 3.4uA.
//so going to try the BLE logic.

#include "mbed.h"
#include "LIS3DH.h" //?? tsai: add SPI link to library here
#include "ble/BLE.h"



#define MyDebugEnb 1
#define sensorEnb 1     //get readings
#define sensorEnb2 1    //enable LISD3H

#if MyDebugEnb
Serial pc(p9, p11);    //Tx, Rx
#endif
//LIS3DH(PinName p_sda, PinName p_scl, uint8_t addr);

//I2C i2c(p6,p7);
//LIS3DH data(i2c, 0x19);


//#define MOSI SPI_PSELMOSI0
#define MOSI p6

//#define MISO SPI_PSELMISO0
#define MISO p4

//#define CS SPI_PSELSS0
#define CS p3

//#define SCLK SPI_PSELSCK0
#define SCLK p7

#if sensorEnb2
static LIS3DH lis(MOSI, MISO, CS, SCLK);    
#endif

DigitalOut LIS_CS_0(CS); //LIS3DH CS

float dt_usr[3];
float x,y,z;


InterruptIn button1(p1);    //nRF51822 P0.0
InterruptIn button2(p2);    //nRF51822 P0.1

/*
static void gpiote_init(void)
{
    // Configure accelerometer interrupt pin
    nrf_gpio_cfg_input(3, NRF_GPIO_PIN_PULLDOWN);
        //nrf_gpio_cfg_input(4, NRF_GPIO_PIN_PULLDOWN);
    
    // Configure GPIOTE channel 0 to generate event when MOTION_INTERRUPT_PIN_NUMBER goes from Low to High
    nrf_gpiote_event_config(0, 3, NRF_GPIOTE_POLARITY_LOTOHI);   //accelerometer int1
        //nrf_gpiote_event_config(1, 4, NRF_GPIOTE_POLARITY_LOTOHI);   //accelerometer int2

    // Enable interrupt for NRF_GPIOTE->EVENTS_IN[0] event
    NRF_GPIOTE->INTENSET  = GPIOTE_INTENSET_IN0_Msk;
    //NRF_GPIOTE->INTENSET |= GPIOTE_INTENSET_IN1_Msk;
}

*/

AxesRaw_t                   accel_raw; 
bool flag_read_acc;

//ISR for I/O interrupt
void button1_int(void)
{
    //#if MyDebugEnb

    //NRF_SPI0->ENABLE = 1;
    //wait_ms(50);
    flag_read_acc=1;
    #if MyDebugEnb
    pc.printf("...interrupt released... \n\r");
    #endif
    
    /*
    pc.printf("x=");
    pc.printf("%i", accel_raw.AXIS_X);
    pc.printf("   y=");
    pc.printf("%i", accel_raw.AXIS_Y);
    pc.printf("   z=");
    pc.printf("%i", accel_raw.AXIS_Z);
    
    pc.printf("button 1=%i, ", button1.read());
    pc.printf("button 2=%i, ", button2.read());
    
    pc.printf("\n\r");
    */
     //#endif
    #if sensorEnb
    lis.LIS3DH_ResetInt1Latch();    //move this to when you really want to release
    //wait(0.5);
    #endif
    
}


/*
//ISR for I/O interrupt
void button2_int(void)
{
    #if sensorEnb
    lis.LIS3DH_GetAccAxesRaw(&accel_raw);
    #endif
    
    #if MyDebugEnb
    pc.printf("...interrupt released... \n\r");
    pc.printf("x=");
    pc.printf("%i", accel_raw.AXIS_X);
    pc.printf("   y=");
    pc.printf("%i", accel_raw.AXIS_Y);
    pc.printf("   z=");
    pc.printf("%i", accel_raw.AXIS_Z);
    
    pc.printf("button 1=%i, ", button1.read());
    pc.printf("button 2=%i, ", button2.read());
    
    pc.printf("\n\r");
    #endif
    
    //x=data.read_data(*dt_usr[0]);
    //y=data.read_data(*dt_usr[1]);
    //z=data.read_data(*dt_usr[2]);
 
    //wait(1.0);
    
     
}
*/

void disconnect_input_buffers()
{
    for(uint8_t i = 0; i < 3; i++)
    {
                    NRF_GPIO->PIN_CNF[i] = (GPIO_PIN_CNF_SENSE_Disabled << GPIO_PIN_CNF_SENSE_Pos)
                                        | (GPIO_PIN_CNF_DRIVE_S0S1 << GPIO_PIN_CNF_DRIVE_Pos)
                                        | (GPIO_PIN_CNF_PULL_Disabled << GPIO_PIN_CNF_PULL_Pos)
                                        | (GPIO_PIN_CNF_INPUT_Disconnect << GPIO_PIN_CNF_INPUT_Pos)
                                        | (GPIO_PIN_CNF_DIR_Output << GPIO_PIN_CNF_DIR_Pos);
    }   
    //Omit accelerometer interrupt pins (3&4)
    for(uint8_t i = 5; i < 21; i++)
    {
                    NRF_GPIO->PIN_CNF[i] = (GPIO_PIN_CNF_SENSE_Disabled << GPIO_PIN_CNF_SENSE_Pos)
                                        | (GPIO_PIN_CNF_DRIVE_S0S1 << GPIO_PIN_CNF_DRIVE_Pos)
                                        | (GPIO_PIN_CNF_PULL_Disabled << GPIO_PIN_CNF_PULL_Pos)
                                        | (GPIO_PIN_CNF_INPUT_Disconnect << GPIO_PIN_CNF_INPUT_Pos)
                                        | (GPIO_PIN_CNF_DIR_Output << GPIO_PIN_CNF_DIR_Pos);
    }   
    //Omit I2C pins (21 & 22)
    for(uint8_t i = 23; i < 31; i++)
    {
                    NRF_GPIO->PIN_CNF[i] = (GPIO_PIN_CNF_SENSE_Disabled << GPIO_PIN_CNF_SENSE_Pos)
                                        | (GPIO_PIN_CNF_DRIVE_S0S1 << GPIO_PIN_CNF_DRIVE_Pos)
                                        | (GPIO_PIN_CNF_PULL_Disabled << GPIO_PIN_CNF_PULL_Pos)
                                        | (GPIO_PIN_CNF_INPUT_Disconnect << GPIO_PIN_CNF_INPUT_Pos)
                                        | (GPIO_PIN_CNF_DIR_Output << GPIO_PIN_CNF_DIR_Pos);
    }
}


int main ()
{
    #if MyDebugEnb
    pc.baud(9600);
    pc.printf("...started... \n\r");
    #endif
    
    
    #if sensorEnb2
    //Initialize SPI interface
    SPI spi(MOSI, MISO, SCLK); // mosi, miso, sclk
    spi.format(8,3);
    spi.frequency(8000000); 
    #endif
    
    BLE &ble = BLE::Instance();
    ble.init(); // normally you'd want to pass a callback for when init completes
    
    //Accelerometer interrupt pin configuration
    //gpiote_init();  

    #if sensorEnb2
    //Initialize LIS3DH driver
    lis.InitLIS3DH(LIS3DH_NORMAL, LIS3DH_ODR_25Hz, LIS3DH_FULLSCALE_2);    //Init Acc-sensor
    //enable threshold to generate interrupt
    lis.SetLIS3DHActivityDetection(10, LIS3DH_INT_MODE_6D_MOVEMENT, 1);
    #endif

    //ticker.attach(senseCallback, 1.0);

    //set both pins to pull-up, so they're not floating when we read state
    button1.mode(PullDown);
    button2.mode(PullDown);
    button1.rise(button1_int);
        //button2.rise(button2_int);
        //button2.fall(button2_int);
     #if sensorEnb2
    lis.LIS3DH_ResetInt1Latch();
    #endif
    
    flag_read_acc = 1;
while (1) {
    
    #if MyDebugEnb
    if (flag_read_acc == 1)
    {
        flag_read_acc=0;
    lis.LIS3DH_GetAccAxesRaw(&accel_raw);
    pc.printf("x=");
    pc.printf("%i", accel_raw.AXIS_X);
    pc.printf("   y=");
    pc.printf("%i", accel_raw.AXIS_Y);
    pc.printf("   z=");
    pc.printf("%i", accel_raw.AXIS_Z);
    
    pc.printf("   button 1=%i, ", button1.read());
    pc.printf("button a=%i, ", button2.read());
    
    pc.printf("\n\r");
    //x=data.read_data(*dt_usr[0]);
    //y=data.read_data(*dt_usr[1]);
    //z=data.read_data(*dt_usr[2]);
    
 
    wait(0.5);
        
    }//end if flag
    

    #endif
    
    
    //NRF_SPI0->ENABLE = 0; //doesn't do anything
    //NRF_SPI1->ENABLE = 0;  //seems to really disable the SPI
    ble.waitForEvent();

    //NRF_SPI0->ENABLE = 1;
    //NRF_SPI1->ENABLE = 1;

    }//end while
}//end main()