//consumes 16uA at ble_wait_for_event()


#include "mbed.h"
#include "LIS3DH.h" //https://developer.mbed.org/users/kenjiArai/code/LIS3DH/
#include "ble/BLE.h"

#define MyDebugEnb 1
#define sensorEnb 1     //get readings


#if MyDebugEnb
Serial pc(p9, p11);    //Tx, Rx
#endif

//LIS3DH(PinName p_sda, PinName p_scl, uint8_t addr);

//I2C i2c(p6,p7);
//LIS3DH data(i2c, 0x19);
#if sensorEnb
//LIS3DH data(p6, p7, (0x19 << 1));  //for purple board, sda=p6, scl=p7
LIS3DH data(p6, p7, LIS3DH_V_CHIP_ADDR); 

//0001 1001  ---> 0011 0010
#endif
float dt_usr[3];
float x,y,z;
InterruptIn button1(p1);    //nRF51822 P0.1
InterruptIn button2(p16);    //nRF51822 P0.1
//InterruptIn button1(p0);
bool flag_read_acc;

uint8_t  reset_addr = 0x31; //LIS3DH_INT1_SOURCE


//ISR for I/O interrupt
void button1_int(void)
{
    //#if MyDebugEnb

    //NRF_SPI0->ENABLE = 1;
    //wait_ms(50);
    flag_read_acc=1;
    #if MyDebugEnb
    pc.printf("...interrupt released... \n\r");
    #endif
    uint8_t retruneddata = data.read_reg(reset_addr);
    pc.printf("%x", retruneddata);
    pc.printf("  returned \n\r");
    
}
//ISR for I/O interrupt
void button2_int(void)
{
    //#if MyDebugEnb

    //NRF_SPI0->ENABLE = 1;
    //wait_ms(50);
    flag_read_acc=1;
    #if MyDebugEnb
    pc.printf("...interrupt from 2... \n\r");
    #endif
    
    
    uint8_t retruneddata = data.read_reg(reset_addr);
    pc.printf("%x", retruneddata);
    pc.printf("  returned \n\r");
    
}



int main ()
{
#if MyDebugEnb
pc.baud(9600);
printf("...started... \n\r");
#endif

    BLE &ble = BLE::Instance();
    ble.init(); // normally you'd want to pass a callback for when init complete
    
    uint8_t setsuccess = data.setAct(LIS3DH_V_CHIP_ADDR);
    #if MyDebugEnb
    pc.printf("%x", setsuccess);
    pc.printf("  set ACT status \n\r");
    #endif
    button1.mode(PullDown);
    button1.rise(button1_int);
    button2.mode(PullDown);
    button2.rise(button2_int);
   
    uint8_t retruneddata = data.read_reg(reset_addr);
    pc.printf("%x", retruneddata);
    pc.printf("  returned \n\r");
while (1) {
    //x=data.read_data(*dt_usr[0]);
    //y=data.read_data(*dt_usr[1]);
    //z=data.read_data(*dt_usr[2]);
    
    #if sensorEnb
    data.read_data(dt_usr);
    #endif
    x=dt_usr[0];
    y=dt_usr[1];
    z=dt_usr[2];
    //y=dt_usr[1];
    //z=dt_usr[2];
    //printf(" %f \n\r", x);
    //printf(" %f \n\r", y);
    //printf(" %f \n\r", z);
    #if MyDebugEnb
    printf("x=%5.2f    y=%5.2f    z=%5.2f \n\r", x, y ,z);
    #endif
    wait_ms(250);
    ble.waitForEvent();
    
    }//end while
}