#ifndef QEI_H
#define QEI_H

/*
    Basic Quadrature Encoder Interface (QEI) Class.
    
    TODO: Expand to allow setting of quad mode, i.e. count on 
    rising of A only, rising and falling of A, rising and falling 
    of both A and B. (Forgot what these modes are called but 
    can be found in literature online.) 
*/

#include "mbed.h"

class QEI{
    public:
        /*
            Constructor for QEI objects
            @param encA     The mbed pin that encoder input A is on
            @param encB     The mbed pin that encoder input B is on
        */
        QEI(PinName encA, PinName encB);
        /*
            read() returns total number of counts of the encoder.
            Count can be +/- and indicates the overall direction,
            (+): CW (-): CCW
            @return     The toltal number of counts of the encoder.
            
            TODO: Add Conversion Overload for this method
        */
        long read();
        /*
            reset() clears the counter to 0. 
        */
        void reset();
    private:
        long count;         // Total number of counts since start.
        InterruptIn _encA;  // Encoder A interrupt pin
        DigitalIn _encB;    // Encoder B input pin
        /*
            Increments/Decrements count on interrrupt.
        */
        void callback();    // Interrupt callback function
};

#endif