#include "QEI.h"

QEI::QEI(PinName encA, PinName encB): _encA(encA), _encB(encB){
    _encA.mode(PullUp);
    _encA.rise(this, &QEI::callback);
    
    _encB.mode(PullUp);
}

long QEI::read(){
    return count;
}

void QEI::reset(){
    count = 0;
}

void QEI::callback(){
    if(_encB) count--;  // CCW count
    else count++;       // CW count    
}