#ifndef LMD18200_H
#define LMD18200_H

#include "mbed.h"

/*
    Very simple class for the LMD18200 H-Bridge Breakout Board
*/

class LMD18200{
    public:
    /*
        Constructor for LMD18200 objects
        @param pwm  PWM Pin used to set speed
        @param dir  Digital Pin used to set direction
    */
    LMD18200(PinName pwm, PinName dir);
    
    /*
        Set speed of motor
        @param spd  The speed of the motor, as a percentage, 
                    normalized between 0 and 1
    */
    void setSpeed(float spd);
    
    /*
        Set the direction of the motor
        @param dir  The direction of the motor, 0 or 1: 0 = FWD, 1 = REVERSE
                    
    */
    void setDirection(int dir);
    
    private:
    PwmOut speed;
    DigitalOut direction;
    /*
        Clamps value between lower and upper values
    */
    float clip(float value, float lower, float upper);
};
#endif