#include "LMD18200.h"
#include <algorithm>

LMD18200::LMD18200(PinName pwm, PinName dir) : speed(pwm), direction(dir){
    speed = 0.0;
    direction = 0;
}

void LMD18200::setSpeed(float spd){
    spd = clip(spd, 0.0, 1.0);      // Clamp value
    speed = spd;                    // Set PWM Speed
}

void LMD18200::setDirection(int dir){
    direction = dir;
}

/*
    Clips value to lower/ uppper
    @param value    The value to clip
    @param lower    The mininum allowable value
    @param upper    The maximum allowable value
    @return         The resulting clipped value
*/
float LMD18200::clip(float value, float lower, float upper){
    return std::max(lower, std::min(value, upper));
}
