#include "mbed.h"
#include "FivePosSwitch.h"

FivePosSwitch::FivePosSwitch(AnalogIn pin):_pin(pin){
}

ACTIVE_POSITION FivePosSwitch::getPosition(){
    float ain = _pin;
    
    if((1.0 - TOLERANCE <= ain) && (ain <= 1.0 + TOLERANCE)) return UP; 
    if((0.8 - TOLERANCE <= ain) && (ain <= 0.8 + TOLERANCE)) return CENTER;
    if((0.6 - TOLERANCE <= ain) && (ain <= 0.6 + TOLERANCE)) return LEFT;
    if((0.4 - TOLERANCE <= ain) && (ain <= 0.4 + TOLERANCE)) return DOWN;
    if((0.2 - TOLERANCE <= ain) && (ain <= 0.2 + TOLERANCE)) return RIGHT;
    else return NONE;
}