/*
    Bryce Williams 
    10/04/2015
    
    Library for modified Sparkfun 5- Way Tact Switch Breakout (Part# BOB-11187)
    
        Breakout Board Mod: Remove the 10k pull- up resistors. This will make 
                            the board a basic breakout for the 5-Way switch. 
                            The Vcc pin (+) can be clipped or left unimplented
                            (i.e. no connect). 
 
        Circuit Setup:
                                   Vcc 
                                   | 
            ----------------       |                                ----------
            |  5- Way   (-)|-------|                                | mBed    |
            |              |        40.0k                           |         |  
            |  Tact     (R)|--------vvv--------|                    |         |  
            |              |        15.0k      |                    |         | 
            |  Switch   (D)|--------vvv--------|                    |         |
            |              |        6.67k      |                    |         |  
            |           (L)|--------vvv--------|--------------------|AnalogIn |    
            |              |        2.5k       |        |           |         |  
            |           (C)|--------vvv--------|        >           |         |  
            |              |                   |        > 10k       |         |  
            |           (U)|-------------------|        >           |         |  
            |              |                            |           |---------
            |           (+)|-----------X               --- 
            ----------------                           GND
        
        Theory of Operation: Each switch output pin is connected to one terminal of
                            a resistor (each of different value). The other terminal 
                            is connected to a single analog in pin on the mBed. 
                            The mBed analog pin is also connected to a 10k resistor
                            running to ground. This makes a network of seperate 
                            voltage dividers, between each switches output pin 
                            resistor and the single 10k resistor from the mBed
                            analog in pin to ground. Since only one position can 
                            be active at a time only one voltage divider voltage 
                            is read by the mBed. Thus each switch position produces
                            a unique voltage, at the analog in pin of the mBed,
                            when active.
                            
        NOTE: For proper operation resistor values should be as close as POSSIBLE
              to those shown in the circuit setup diagram!                        
*/
#ifndef FIVE_POS_SWITCH
#define FIVE_POS_SWITCH
#include "mbed.h"

enum ACTIVE_POSITION{NONE = 0, UP = -1, CENTER = -2, LEFT = -3, DOWN = -4, RIGHT = -5};

class FivePosSwitch{
    public:
        /** Constructor for FivePosSwitch
            @param <pin> The AnalogIn Pin
        */ 
        FivePosSwitch(AnalogIn pin);
        /** Get the currently pressed switch position
            @return The currently pressed switch position 
        */
        ACTIVE_POSITION getPosition();
    private:
        AnalogIn _pin;
        static const float TOLERANCE = 0.075;     // Allowable tolerance in evaluating for active switch
                                                  // (0.075 will give a 0.05 deadband between posistions)
};

#endif