#include "FibonacciLFSR.h"
#include "mbed.h"

FibonacciLFSR::FibonacciLFSR(LFSR_SIZE_t size){
    this->size = size;
    this->lfsr_period = (1 << size) - 1;    // Number of random numbers
    this->lfsr = 0x0001;
}

uint16_t FibonacciLFSR::getRandom(){
    switch (size){
        case LFSR_2:
            feedback_bit = ((lfsr >> 1) ^ (lfsr >> 0)) & 0x01;
            break;
        case LFSR_4:
            feedback_bit = ((lfsr >> 3) ^ (lfsr >> 2)) & 0x01;
            break;
        case LFSR_8:
            feedback_bit = ((lfsr >> 7) ^ (lfsr >> 5) ^ (lfsr >> 4) ^ (lfsr >> 3)) & 0x01;
            break;
        case LFSR_16:
            feedback_bit = ((lfsr >> 15) ^ (lfsr >> 14) ^ (lfsr >> 12) ^ (lfsr >> 3)) & 0x01;
            break;
        default: 
            break;
    }
    
    // Shift, add feedback, AND zero extra MSb's leaving only "size" number of bits representing lfsr
    lfsr = ((lfsr << 1) | feedback_bit) & ((1 << size) - 1); 
    return lfsr;
}