#ifndef FIBONACCI_LFSR
#define FIBONACCI_LFSR

/*
    Library for Fibonacci Linear Feedback Shift Register pseudo-random number
    generator. The uniqueness of the Fibonacci LFSR is that all permutations
    (values) are explored except zero, ensuring at least one bit in the LFSR
    is always HIGH. 
    
    Applications: Random Number Generation, LED Faux Candles, LED lighting 
    effects, etc. 
    
    References: (Press "Ctrl" and click link to open in browser)
    https://en.wikipedia.org/wiki/Linear-feedback_shift_register
    
    TODO: Consider making this class static
*/

#include "mbed.h"

class FibonacciLFSR{
    public:
        typedef enum SIZE{
            LFSR_2 = 2, LFSR_4 = 4, 
            LFSR_8 = 8, LFSR_16 = 16
        }LFSR_SIZE_t;
        /*
            Constructor of Fibonacci Linear Feedback Shift Register Objects.
            Preconditions: None
            @param size     Number of bits for LFSR 
        */   
        FibonacciLFSR(LFSR_SIZE_t size);
        
        /*
            Generate and return new random number
            @return    A new random value
        */
        uint16_t getRandom();
        
    private:
        LFSR_SIZE_t size;              // The number of bits representing the LFSR
        int lfsr_period;               // Period of LFSR register (number of random values before repeating)
        uint16_t lfsr;              
        uint16_t feedback_bit;      
};
#endif